/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.util.HashSet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanConfigurer;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanCustomizer;

@Configuration(proxyBeanMethods=false)
public class KafkaStreamsDefaultConfiguration {
    public static final String DEFAULT_STREAMS_CONFIG_BEAN_NAME = "defaultKafkaStreamsConfig";
    public static final String DEFAULT_STREAMS_BUILDER_BEAN_NAME = "defaultKafkaStreamsBuilder";

    @Bean(name={"defaultKafkaStreamsBuilder"})
    public StreamsBuilderFactoryBean defaultKafkaStreamsBuilder(@Qualifier(value="defaultKafkaStreamsConfig") ObjectProvider<KafkaStreamsConfiguration> streamsConfigProvider, ObjectProvider<StreamsBuilderFactoryBeanCustomizer> customizerProvider, ObjectProvider<StreamsBuilderFactoryBeanConfigurer> configurerProvider) {
        KafkaStreamsConfiguration streamsConfig = (KafkaStreamsConfiguration)streamsConfigProvider.getIfAvailable();
        if (streamsConfig != null) {
            StreamsBuilderFactoryBean fb = new StreamsBuilderFactoryBean(streamsConfig);
            HashSet configuredBy = new HashSet();
            configurerProvider.orderedStream().forEach(configurer -> {
                configurer.configure(fb);
                configuredBy.add(configurer);
            });
            StreamsBuilderFactoryBeanCustomizer customizer = (StreamsBuilderFactoryBeanCustomizer)customizerProvider.getIfUnique();
            if (customizer != null && !configuredBy.contains(customizer)) {
                customizer.configure(fb);
            }
            return fb;
        }
        throw new UnsatisfiedDependencyException(KafkaStreamsDefaultConfiguration.class.getName(), DEFAULT_STREAMS_BUILDER_BEAN_NAME, "streamsConfig", "There is no 'defaultKafkaStreamsConfig' " + KafkaStreamsConfiguration.class.getName() + " bean in the application context.\nConsider declaring one or don't use @EnableKafkaStreams.");
    }
}

