/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.util.Assert;

public class CompositeProducerListener<K, V>
implements ProducerListener<K, V> {
    private final List<ProducerListener<K, V>> delegates = new CopyOnWriteArrayList<ProducerListener<K, V>>();

    @SafeVarargs
    public CompositeProducerListener(ProducerListener<K, V> ... delegates) {
        this.setDelegates(delegates);
    }

    @SafeVarargs
    public final void setDelegates(ProducerListener<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot contain null elements");
        this.delegates.clear();
        this.delegates.addAll(Arrays.asList(delegates));
    }

    protected List<ProducerListener<K, V>> getDelegates() {
        return this.delegates;
    }

    public void addDelegate(ProducerListener<K, V> delegate) {
        this.delegates.add(delegate);
    }

    public boolean removeDelegate(ProducerListener<K, V> delegate) {
        return this.delegates.remove(delegate);
    }

    @Override
    public void onSuccess(ProducerRecord<K, V> producerRecord, RecordMetadata recordMetadata) {
        this.delegates.forEach(d -> d.onSuccess(producerRecord, recordMetadata));
    }

    @Override
    @Deprecated
    public void onError(ProducerRecord<K, V> producerRecord, Exception exception) {
        this.delegates.forEach(d -> d.onError(producerRecord, exception));
    }

    @Override
    public void onError(ProducerRecord<K, V> producerRecord, RecordMetadata recordMetadata, Exception exception) {
        this.delegates.forEach(d -> d.onError(producerRecord, recordMetadata, exception));
    }
}

