/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.util.ObjectUtils;

public class LoggingProducerListener<K, V>
implements ProducerListener<K, V> {
    public static final int DEFAULT_MAX_CONTENT_LOGGED = 100;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private boolean includeContents = true;
    private int maxContentLogged = 100;

    public void setIncludeContents(boolean includeContents) {
        this.includeContents = includeContents;
    }

    public void setMaxContentLogged(int maxContentLogged) {
        this.maxContentLogged = maxContentLogged;
    }

    @Override
    public void onError(ProducerRecord<K, V> record, Exception exception) {
        this.logger.error((Throwable)exception, () -> {
            StringBuffer logOutput = new StringBuffer();
            logOutput.append("Exception thrown when sending a message");
            if (this.includeContents) {
                logOutput.append(" with key='").append(this.keyOrValue(record.key())).append("'").append(" and payload='").append(this.keyOrValue(record.value())).append("'");
            }
            logOutput.append(" to topic ").append(record.topic());
            if (record.partition() != null) {
                logOutput.append(" and partition ").append(record.partition());
            }
            logOutput.append(":");
            return logOutput.toString();
        });
    }

    private String keyOrValue(Object keyOrValue) {
        if (keyOrValue instanceof byte[]) {
            return "byte[" + ((byte[])keyOrValue).length + "]";
        }
        return this.toDisplayString(ObjectUtils.nullSafeToString((Object)keyOrValue), this.maxContentLogged);
    }

    private String toDisplayString(String original, int maxCharacters) {
        if (original.length() <= maxCharacters) {
            return original;
        }
        return original.substring(0, maxCharacters) + "...";
    }
}

