/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchConsumerAwareMessageListener;
import org.springframework.kafka.listener.ConsumerAwareMessageListener;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.ListenerType;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ListenerUtils {
    private ListenerUtils() {
    }

    public static ListenerType determineListenerType(Object listener) {
        ListenerType listenerType;
        Assert.notNull((Object)listener, (String)"Listener cannot be null");
        if (listener instanceof AcknowledgingConsumerAwareMessageListener || listener instanceof BatchAcknowledgingConsumerAwareMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING_CONSUMER_AWARE;
        } else if (listener instanceof ConsumerAwareMessageListener || listener instanceof BatchConsumerAwareMessageListener) {
            listenerType = ListenerType.CONSUMER_AWARE;
        } else if (listener instanceof AcknowledgingMessageListener || listener instanceof BatchAcknowledgingMessageListener) {
            listenerType = ListenerType.ACKNOWLEDGING;
        } else if (listener instanceof GenericMessageListener) {
            listenerType = ListenerType.SIMPLE;
        } else {
            throw new IllegalArgumentException("Unsupported listener type: " + listener.getClass().getName());
        }
        return listenerType;
    }

    @Nullable
    public static DeserializationException getExceptionFromHeader(ConsumerRecord<?, ?> record, String headerName, LogAccessor logger) {
        Header header = record.headers().lastHeader(headerName);
        if (header != null) {
            try {
                DeserializationException ex = (DeserializationException)((Object)new ObjectInputStream(new ByteArrayInputStream(header.value())).readObject());
                RecordHeaders headers = new RecordHeaders((Iterable)Arrays.stream(record.headers().toArray()).filter(h -> !h.key().startsWith("springDeserializerException")).collect(Collectors.toList()));
                ex.setHeaders((Headers)headers);
                return ex;
            }
            catch (IOException | ClassCastException | ClassNotFoundException e) {
                logger.error((Throwable)e, (CharSequence)"Failed to deserialize a deserialization exception");
            }
        }
        return null;
    }
}

