/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

public class KafkaStreamsConfiguration {
    private final Map<String, Object> configs;
    private final DefaultConversionService conversionService = new DefaultConversionService();
    private Properties properties;

    public KafkaStreamsConfiguration(Map<String, Object> configs) {
        Assert.notNull(configs, (String)"Configuration map cannot be null");
        this.configs = new HashMap<String, Object>(configs);
        this.conversionService.addConverter(new Converter<Class<?>, String>(){

            public String convert(Class<?> c) {
                return c.getName();
            }
        });
        this.conversionService.addConverter(new Converter<List<?>, String>(){

            public String convert(List<?> l) {
                String value = l.toString();
                return value.substring(1, value.length() - 1);
            }
        });
    }

    public Properties asProperties() {
        if (this.properties == null) {
            Properties properties = new Properties();
            this.configs.forEach((k, v) -> {
                String value = this.conversionService.canConvert(v.getClass(), String.class) ? (String)this.conversionService.convert(v, String.class) : v.toString();
                properties.setProperty((String)k, value);
            });
            this.properties = properties;
        }
        return this.properties;
    }
}

