/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.MimeType;

public class MimeTypeJsonDeserializer
extends StdNodeBasedDeserializer<MimeType> {
    private static final long serialVersionUID = 1L;
    private final ObjectMapper mapper;

    public MimeTypeJsonDeserializer(ObjectMapper mapper) {
        super(MimeType.class);
        this.mapper = mapper;
    }

    public MimeType convert(JsonNode root, DeserializationContext ctxt) throws IOException {
        JsonNode type = root.get("type");
        JsonNode subType = root.get("subtype");
        JsonNode parameters = root.get("parameters");
        Map params = (Map)this.mapper.readValue(parameters.traverse(), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class));
        return new MimeType(type.asText(), subType.asText(), params);
    }
}

