/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.listener.KafkaListenerErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordMessagingMessageListenerAdapter;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodKafkaListenerEndpoint<K, V>
extends AbstractKafkaListenerEndpoint<K, V> {
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private KafkaListenerErrorHandler errorHandler;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setErrorHandler(KafkaListenerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private String getReplyTopic() {
        SendTo ann;
        Method method = this.getMethod();
        if (method != null && (ann = (SendTo)AnnotationUtils.getAnnotation((Method)method, SendTo.class)) != null) {
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + method + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            return destinations.length == 1 ? this.resolve(destinations[0]) : "";
        }
        return null;
    }

    protected MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    @Override
    protected MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer container, MessageConverter messageConverter) {
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter messageListener = this.createMessageListenerInstance(messageConverter);
        messageListener.setHandlerMethod(this.configureListenerAdapter(messageListener));
        String replyTopic = this.getReplyTopic();
        if (replyTopic != null) {
            Assert.state((this.getReplyTemplate() != null ? 1 : 0) != 0, (String)"a KafkaTemplate is required to support replies");
            messageListener.setReplyTopic(replyTopic);
        }
        if (this.getReplyTemplate() != null) {
            messageListener.setReplyTemplate(this.getReplyTemplate());
        }
        return messageListener;
    }

    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter<K, V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected MessagingMessageListenerAdapter<K, V> createMessageListenerInstance(MessageConverter messageConverter) {
        MessagingMessageListenerAdapter listener;
        if (this.isBatchListener()) {
            BatchMessagingMessageListenerAdapter messageListener = new BatchMessagingMessageListenerAdapter(this.bean, this.method, this.errorHandler);
            if (messageConverter instanceof BatchMessageConverter) {
                messageListener.setBatchMessageConverter((BatchMessageConverter)messageConverter);
            }
            listener = messageListener;
        } else {
            RecordMessagingMessageListenerAdapter messageListener = new RecordMessagingMessageListenerAdapter(this.bean, this.method, this.errorHandler);
            if (messageConverter instanceof RecordMessageConverter) {
                messageListener.setMessageConverter((RecordMessageConverter)messageConverter);
            }
            listener = messageListener;
        }
        if (this.getBeanResolver() != null) {
            listener.setBeanResolver(this.getBeanResolver());
        }
        return listener;
    }

    private String resolve(String value) {
        if (this.getResolver() != null) {
            Object newValue = this.getResolver().evaluate(value, this.getBeanExpressionContext());
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }
}

