/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.MethodParameter;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.adapter.HandlerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;

public abstract class MessagingMessageListenerAdapter<K, V>
implements ConsumerSeekAware {
    private final Object bean;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Type inferredType;
    private HandlerAdapter handlerMethod;
    private boolean isConsumerRecordList;
    private boolean isMessageList;
    private RecordMessageConverter messageConverter = new MessagingMessageConverter();
    private Type fallbackType = Object.class;

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this.bean = bean;
        this.inferredType = this.determineInferredType(method);
    }

    public void setMessageConverter(RecordMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected final RecordMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    protected Type getType() {
        return this.inferredType == null ? this.fallbackType : this.inferredType;
    }

    public void setFallbackType(Class<?> fallbackType) {
        this.fallbackType = fallbackType;
    }

    public void setHandlerMethod(HandlerAdapter handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    protected boolean isConsumerRecordList() {
        return this.isConsumerRecordList;
    }

    protected boolean isMessageList() {
        return this.isMessageList;
    }

    @Override
    public void registerSeekCallback(ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).registerSeekCallback(callback);
        }
    }

    @Override
    public void onPartitionsAssigned(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).onPartitionsAssigned(assignments, callback);
        }
    }

    @Override
    public void onIdleContainer(Map<TopicPartition, Long> assignments, ConsumerSeekAware.ConsumerSeekCallback callback) {
        if (this.bean instanceof ConsumerSeekAware) {
            ((ConsumerSeekAware)this.bean).onIdleContainer(assignments, callback);
        }
    }

    protected Message<?> toMessagingMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
        return this.getMessageConverter().toMessage(record, acknowledgment, this.getType());
    }

    protected final Object invokeHandler(Object data, Acknowledgment acknowledgment, Message<?> message) {
        try {
            if (data instanceof List && !this.isConsumerRecordList) {
                return this.handlerMethod.invoke(message, acknowledgment);
            }
            return this.handlerMethod.invoke(message, data, acknowledgment);
        }
        catch (MessageConversionException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), new MessageConversionException("Cannot handle message", (Throwable)ex));
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerMethod.getMethodAsString(message.getPayload()) + "' threw exception", ex);
        }
    }

    protected final String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerMethod.getMethodAsString(payload) + "]\nBean [" + this.handlerMethod.getBean() + "]";
    }

    protected Type determineInferredType(Method method) {
        if (method == null) {
            return null;
        }
        Type genericParameterType = null;
        boolean hasAck = false;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            if (this.eligibleParameter(methodParameter) && (methodParameter.getParameterAnnotations().length == 0 || methodParameter.hasParameterAnnotation(Payload.class))) {
                if (genericParameterType == null) {
                    genericParameterType = methodParameter.getGenericParameterType();
                    if (!(genericParameterType instanceof ParameterizedType)) continue;
                    ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
                    if (parameterizedType.getRawType().equals(Message.class)) {
                        genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                        continue;
                    }
                    if (!parameterizedType.getRawType().equals(List.class) || parameterizedType.getActualTypeArguments().length != 1) continue;
                    Type paramType = parameterizedType.getActualTypeArguments()[0];
                    this.isConsumerRecordList = paramType.equals(ConsumerRecord.class) || paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(ConsumerRecord.class);
                    this.isMessageList = paramType.equals(Message.class) || paramType instanceof ParameterizedType && ((ParameterizedType)paramType).getRawType().equals(Message.class);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Ambiguous parameters for target payload for method " + method + "; no inferred type available"));
                break;
            }
            if (!methodParameter.getGenericParameterType().equals(Acknowledgment.class)) continue;
            hasAck = true;
        }
        Assert.state((!this.isConsumerRecordList || method.getParameterTypes().length == 1 || method.getGenericParameterTypes().length == 2 && hasAck ? 1 : 0) != 0, (String)"A parameter of type 'List<ConsumerRecord>' must be the only parameter (except for an optional 'Acknowledgment')");
        Assert.state((!this.isMessageList || method.getParameterTypes().length == 1 || method.getGenericParameterTypes().length == 2 && hasAck ? 1 : 0) != 0, (String)"A parameter of type 'List<Message<?>>' must be the only parameter (except for an optional 'Acknowledgment')");
        return genericParameterType;
    }

    private boolean eligibleParameter(MethodParameter methodParameter) {
        ParameterizedType parameterizedType;
        Type parameterType = methodParameter.getGenericParameterType();
        if (parameterType.equals(Acknowledgment.class) || parameterType.equals(ConsumerRecord.class)) {
            return false;
        }
        if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
            return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
        }
        return !parameterType.equals(Message.class);
    }
}

