/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.TransactionSupport;
import org.springframework.util.Assert;

public class DefaultKafkaProducerFactory<K, V>
implements ProducerFactory<K, V>,
Lifecycle,
DisposableBean {
    private static final int DEFAULT_PHYSICAL_CLOSE_TIMEOUT = 30;
    private static final Log logger = LogFactory.getLog(DefaultKafkaProducerFactory.class);
    private final Map<String, Object> configs;
    private final AtomicInteger transactionIdSuffix = new AtomicInteger();
    private final BlockingQueue<CloseSafeProducer<K, V>> cache = new LinkedBlockingQueue<CloseSafeProducer<K, V>>();
    private final Map<String, CloseSafeProducer<K, V>> consumerProducers = new HashMap<String, CloseSafeProducer<K, V>>();
    private final AtomicInteger clientIdCounter = new AtomicInteger();
    private volatile CloseSafeProducer<K, V> producer;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private int physicalCloseTimeout = 30;
    private String transactionIdPrefix;
    private volatile boolean running;
    private boolean producerPerConsumerPartition = true;
    private String clientIdPrefix;

    public DefaultKafkaProducerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultKafkaProducerFactory(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.configs = new HashMap<String, Object>(configs);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        if (configs.get("client.id") instanceof String) {
            this.clientIdPrefix = (String)configs.get("client.id");
        }
    }

    public void setKeySerializer(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setPhysicalCloseTimeout(int physicalCloseTimeout) {
        this.physicalCloseTimeout = physicalCloseTimeout;
    }

    public void setTransactionIdPrefix(String transactionIdPrefix) {
        Assert.notNull((Object)transactionIdPrefix, (String)"'transactionIdPrefix' cannot be null");
        this.transactionIdPrefix = transactionIdPrefix;
    }

    public void setProducerPerConsumerPartition(boolean producerPerConsumerPartition) {
        this.producerPerConsumerPartition = producerPerConsumerPartition;
    }

    public boolean isProducerPerConsumerPartition() {
        return this.producerPerConsumerPartition;
    }

    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public boolean transactionCapable() {
        return this.transactionIdPrefix != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CloseSafeProducer<K, V> producerToClose;
        Object object = this;
        synchronized (object) {
            producerToClose = this.producer;
            this.producer = null;
        }
        if (producerToClose != null) {
            ((CloseSafeProducer)producerToClose).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
        }
        this.producer = (CloseSafeProducer)this.cache.poll();
        while (this.producer != null) {
            try {
                ((CloseSafeProducer)producerToClose).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while closing producer", (Throwable)e);
            }
            this.producer = (CloseSafeProducer)this.cache.poll();
        }
        object = this.consumerProducers;
        synchronized (object) {
            for (Map.Entry<String, CloseSafeProducer<K, V>> entry : this.consumerProducers.entrySet()) {
                ((CloseSafeProducer)entry.getValue()).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
            }
            this.consumerProducers.clear();
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        try {
            this.destroy();
            this.running = false;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while closing producer", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Producer<K, V> createProducer() {
        if (this.transactionIdPrefix != null) {
            if (this.producerPerConsumerPartition) {
                return this.createTransactionalProducerForPartition();
            }
            return this.createTransactionalProducer();
        }
        DefaultKafkaProducerFactory defaultKafkaProducerFactory = this;
        synchronized (defaultKafkaProducerFactory) {
            if (this.producer == null) {
                this.producer = new CloseSafeProducer<K, V>(this.createKafkaProducer(), this.standardProducerRemover(), this.physicalCloseTimeout);
            }
            return this.producer;
        }
    }

    protected Producer<K, V> createKafkaProducer() {
        if (this.clientIdPrefix == null) {
            return new KafkaProducer(this.configs, this.keySerializer, this.valueSerializer);
        }
        HashMap<String, Object> newConfigs = new HashMap<String, Object>(this.configs);
        newConfigs.put("client.id", this.clientIdPrefix + "-" + this.clientIdCounter.incrementAndGet());
        return new KafkaProducer(newConfigs, this.keySerializer, this.valueSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Producer<K, V> createTransactionalProducerForPartition() {
        String suffix = TransactionSupport.getTransactionIdSuffix();
        if (suffix == null) {
            return this.createTransactionalProducer();
        }
        Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
        synchronized (map) {
            if (!this.consumerProducers.containsKey(suffix)) {
                CloseSafeProducer<K, V> newProducer = this.doCreateTxProducer(suffix, true);
                this.consumerProducers.put(suffix, newProducer);
                return newProducer;
            }
            return this.consumerProducers.get(suffix);
        }
    }

    protected final synchronized void removeProducer(CloseSafeProducer<K, V> producerToRemove) {
        if (producerToRemove.equals(this.producer)) {
            this.producer = null;
        }
    }

    protected Producer<K, V> createTransactionalProducer() {
        Producer producer = (Producer)this.cache.poll();
        if (producer == null) {
            return this.doCreateTxProducer("" + this.transactionIdSuffix.getAndIncrement(), false);
        }
        return producer;
    }

    private CloseSafeProducer<K, V> doCreateTxProducer(String suffix, boolean isConsumerProducer) {
        HashMap<String, Object> configs = new HashMap<String, Object>(this.configs);
        configs.put("transactional.id", this.transactionIdPrefix + suffix);
        if (this.clientIdPrefix != null) {
            configs.put("client.id", this.clientIdPrefix + "-" + this.clientIdCounter.incrementAndGet());
        }
        KafkaProducer producer = new KafkaProducer(configs, this.keySerializer, this.valueSerializer);
        producer.initTransactions();
        Remover<K, V> remover = isConsumerProducer ? this.consumerProducerRemover() : null;
        return new CloseSafeProducer<K, V>(producer, this.cache, remover, (String)configs.get("transactional.id"), this.physicalCloseTimeout);
    }

    private Remover<K, V> standardProducerRemover() {
        return new Remover<K, V>(){

            @Override
            public void remove(CloseSafeProducer<K, V> producer) {
                DefaultKafkaProducerFactory.this.removeProducer(producer);
            }
        };
    }

    private Remover<K, V> consumerProducerRemover() {
        return new Remover<K, V>(){

            @Override
            public void remove(CloseSafeProducer<K, V> producer) {
                DefaultKafkaProducerFactory.this.removeConsumerProducer(producer);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerProducer(CloseSafeProducer<K, V> producer) {
        Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
        synchronized (map) {
            Iterator<Map.Entry<String, CloseSafeProducer<K, V>>> iterator = this.consumerProducers.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(producer)) continue;
                iterator.remove();
                break;
            }
        }
    }

    protected BlockingQueue<CloseSafeProducer<K, V>> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProducerFor(String transactionIdSuffix) {
        if (this.producerPerConsumerPartition) {
            Map<String, CloseSafeProducer<K, V>> map = this.consumerProducers;
            synchronized (map) {
                CloseSafeProducer<K, V> removed = this.consumerProducers.remove(transactionIdSuffix);
                if (removed != null) {
                    ((CloseSafeProducer)removed).delegate.close((long)this.physicalCloseTimeout, TimeUnit.SECONDS);
                }
            }
        }
    }

    protected static class CloseSafeProducer<K, V>
    implements Producer<K, V> {
        private final Producer<K, V> delegate;
        private final BlockingQueue<CloseSafeProducer<K, V>> cache;
        private final String txId;
        private final Remover<K, V> remover;
        private final int closeTimeout;
        private volatile Exception producerFailed;
        private volatile boolean closed;

        CloseSafeProducer(Producer<K, V> delegate, Remover<K, V> remover, int closeTimeout) {
            this(delegate, null, remover, null, closeTimeout);
            Assert.isTrue((!(delegate instanceof CloseSafeProducer) ? 1 : 0) != 0, (String)"Cannot double-wrap a producer");
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache, int closeTimeout) {
            this(delegate, cache, null, closeTimeout);
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache, Remover<K, V> remover, int closeTimeout) {
            this(delegate, cache, remover, null, closeTimeout);
        }

        CloseSafeProducer(Producer<K, V> delegate, BlockingQueue<CloseSafeProducer<K, V>> cache, Remover<K, V> remover, String txId, int closeTimeout) {
            this.delegate = delegate;
            this.cache = cache;
            this.remover = remover;
            this.txId = txId;
            this.closeTimeout = closeTimeout;
        }

        Producer<K, V> getDelegate() {
            return this.delegate;
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
            return this.delegate.send(record);
        }

        public Future<RecordMetadata> send(ProducerRecord<K, V> record, final Callback callback) {
            return this.delegate.send(record, new Callback(){

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if (exception instanceof OutOfOrderSequenceException) {
                        CloseSafeProducer.this.producerFailed = exception;
                        CloseSafeProducer.this.close(CloseSafeProducer.this.closeTimeout, TimeUnit.MILLISECONDS);
                    }
                    callback.onCompletion(metadata, exception);
                }
            });
        }

        public void flush() {
            this.delegate.flush();
        }

        public List<PartitionInfo> partitionsFor(String topic) {
            return this.delegate.partitionsFor(topic);
        }

        public Map<MetricName, ? extends Metric> metrics() {
            return this.delegate.metrics();
        }

        public void initTransactions() {
            this.delegate.initTransactions();
        }

        public void beginTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("beginTransaction: " + this));
            }
            try {
                this.delegate.beginTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("beginTransaction failed: " + this), (Throwable)e);
                }
                this.producerFailed = e;
                throw e;
            }
        }

        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
            this.delegate.sendOffsetsToTransaction(offsets, consumerGroupId);
        }

        public void commitTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("commitTransaction: " + this));
            }
            try {
                this.delegate.commitTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("commitTransaction failed: " + this), (Throwable)e);
                }
                this.producerFailed = e;
                throw e;
            }
        }

        public void abortTransaction() throws ProducerFencedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("abortTransaction: " + this));
            }
            try {
                this.delegate.abortTransaction();
            }
            catch (RuntimeException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Abort failed: " + this), (Throwable)e);
                }
                this.producerFailed = e;
                throw e;
            }
        }

        public void close() {
            this.close(0L, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(long timeout, TimeUnit unit) {
            if (!this.closed) {
                if (this.producerFailed != null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Error during transactional operation; producer removed from cache; possible cause: broker restarted during transaction: " + this));
                    }
                    this.closed = true;
                    this.delegate.close(this.producerFailed instanceof TimeoutException || unit == null ? 0L : timeout, unit);
                    if (this.remover != null) {
                        this.remover.remove(this);
                    }
                } else if (this.cache != null && this.remover == null) {
                    CloseSafeProducer closeSafeProducer = this;
                    synchronized (closeSafeProducer) {
                        if (!this.cache.contains(this) && !this.cache.offer(this)) {
                            this.closed = true;
                            this.delegate.close((long)this.closeTimeout, unit);
                        }
                    }
                }
            }
        }

        public String toString() {
            return "CloseSafeProducer [delegate=" + this.delegate + "" + (this.txId != null ? ", txId=" + this.txId : "") + "]";
        }
    }

    static interface Remover<K, V> {
        public void remove(CloseSafeProducer<K, V> var1);
    }
}

