/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.support.Acknowledgment;

public class FilteringAcknowledgingMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V, AcknowledgingMessageListener<K, V>>
implements AcknowledgingMessageListener<K, V> {
    private final boolean ackDiscarded;

    public FilteringAcknowledgingMessageListenerAdapter(AcknowledgingMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy, boolean ackDiscarded) {
        super(delegate, recordFilterStrategy);
        this.ackDiscarded = ackDiscarded;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> consumerRecord, Acknowledgment acknowledgment) {
        if (!this.filter(consumerRecord)) {
            ((AcknowledgingMessageListener)this.delegate).onMessage(consumerRecord, acknowledgment);
        } else if (this.ackDiscarded && acknowledgment != null) {
            acknowledgment.acknowledge();
        }
    }
}

