/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.lang.reflect.Method;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.Message;

public class RecordMessagingMessageListenerAdapter<K, V>
extends MessagingMessageListenerAdapter<K, V>
implements MessageListener<K, V>,
AcknowledgingMessageListener<K, V> {
    public RecordMessagingMessageListenerAdapter(Object bean, Method method) {
        super(bean, method);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record) {
        this.onMessage(record, (Acknowledgment)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment) {
        Message<?> message = this.toMessagingMessage(record, acknowledgment);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        this.invokeHandler(record, acknowledgment, message);
    }
}

