/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.adapter.AbstractFilteringMessageListener;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;

public class FilteringBatchMessageListenerAdapter<K, V>
extends AbstractFilteringMessageListener<K, V, BatchMessageListener<K, V>>
implements BatchMessageListener<K, V> {
    public FilteringBatchMessageListenerAdapter(BatchMessageListener<K, V> delegate, RecordFilterStrategy<K, V> recordFilterStrategy) {
        super(delegate, recordFilterStrategy);
    }

    @Override
    public void onMessage(List<ConsumerRecord<K, V>> consumerRecords) {
        Iterator<ConsumerRecord<K, V>> iterator = consumerRecords.iterator();
        while (iterator.hasNext()) {
            if (!this.filter(iterator.next())) continue;
            iterator.remove();
        }
        if (consumerRecords.size() > 0) {
            ((BatchMessageListener)this.delegate).onMessage(consumerRecords);
        }
    }
}

