/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.test.utils.KafkaTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class ContainerTestUtils {
    private ContainerTestUtils() {
    }

    public static void waitForAssignment(Object container, int partitions) {
        if (container.getClass().getSimpleName().contains("KafkaMessageListenerContainer")) {
            ContainerTestUtils.waitForSingleContainerAssignment(container, partitions);
            return;
        }
        List containers = KafkaTestUtils.getPropertyValue(container, "containers", List.class);
        Assert.notNull((Object)containers, (String)"Containers must not be null");
        int n = 0;
        int count = 0;
        Method getAssignedPartitions = null;
        while (n++ < 600 && count < partitions) {
            count = 0;
            for (Object aContainer : containers) {
                Collection assignedPartitions;
                if (getAssignedPartitions == null) {
                    getAssignedPartitions = ContainerTestUtils.getAssignedPartitionsMethod(aContainer.getClass());
                }
                try {
                    assignedPartitions = (Collection)getAssignedPartitions.invoke(aContainer, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new ContainerTestUtilsException("Failed to invoke container method", e);
                }
                if (assignedPartitions == null) continue;
                count += assignedPartitions.size();
            }
            if (count >= partitions) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (count != partitions) {
            throw new IllegalStateException(String.format("Expected %d but got %d partitions", partitions, count));
        }
    }

    private static void waitForSingleContainerAssignment(Object container, int partitions) {
        int n = 0;
        int count = 0;
        Method getAssignedPartitions = ContainerTestUtils.getAssignedPartitionsMethod(container.getClass());
        while (n++ < 600 && count < partitions) {
            Collection assignedPartitions;
            count = 0;
            try {
                assignedPartitions = (Collection)getAssignedPartitions.invoke(container, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                throw new ContainerTestUtilsException("Failed to invoke container method", e1);
            }
            if (assignedPartitions != null) {
                count = assignedPartitions.size();
            }
            if (count >= partitions) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (count != partitions) {
            throw new IllegalStateException(String.format("Expected %d but got %d partitions", partitions, count));
        }
    }

    private static Method getAssignedPartitionsMethod(Class<?> clazz) {
        AtomicReference<@Nullable V> theMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(clazz, theMethod::set, method -> method.getName().equals("getAssignedPartitions") && method.getParameterTypes().length == 0);
        Method method2 = (Method)theMethod.get();
        Assert.state((method2 != null ? 1 : 0) != 0, (String)"No getAssignedPartitions() method");
        return method2;
    }

    private static class ContainerTestUtilsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ContainerTestUtilsException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

