/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.kafka.test.rule.KafkaEmbedded;
import org.springframework.util.Assert;

public final class KafkaTestUtils {
    private KafkaTestUtils() {
    }

    public static Map<String, Object> consumerProps(String group, String autoCommit, KafkaEmbedded embeddedKafka) {
        return KafkaTestUtils.consumerProps(embeddedKafka.getBrokersAsString(), group, autoCommit);
    }

    public static Map<String, Object> producerProps(KafkaEmbedded embeddedKafka) {
        return KafkaTestUtils.senderProps(embeddedKafka.getBrokersAsString());
    }

    public static Map<String, Object> consumerProps(String brokers, String group, String autoCommit) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", brokers);
        props.put("group.id", group);
        props.put("enable.auto.commit", autoCommit);
        props.put("auto.commit.interval.ms", "10");
        props.put("session.timeout.ms", 60000);
        props.put("key.deserializer", IntegerDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        return props;
    }

    public static Map<String, Object> senderProps(String brokers) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", brokers);
        props.put("retries", 0);
        props.put("batch.size", 16384);
        props.put("linger.ms", 1);
        props.put("buffer.memory", 0x2000000);
        props.put("key.serializer", IntegerSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return props;
    }

    public static <K, V> ConsumerRecord<K, V> getSingleRecord(Consumer<K, V> consumer, String topic) {
        ConsumerRecords<K, V> received = KafkaTestUtils.getRecords(consumer);
        ((AbstractIntegerAssert)Assertions.assertThat((int)received.count()).as("Incorrect results returned", new Object[]{received.count()})).isEqualTo(1);
        return (ConsumerRecord)received.records(topic).iterator().next();
    }

    public static <K, V> ConsumerRecords<K, V> getRecords(Consumer<K, V> consumer) {
        ConsumerRecords received = consumer.poll(20000L);
        ((IterableAssert)Assertions.assertThat((Iterable)received).as("null received from consumer.poll()", new Object[0])).isNotNull();
        return received;
    }

    public static Object getPropertyValue(Object root, String propertyPath) {
        Object value = null;
        DirectFieldAccessor accessor = new DirectFieldAccessor(root);
        String[] tokens = propertyPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            value = accessor.getPropertyValue(tokens[i]);
            if (value == null) {
                if (i == tokens.length - 1) {
                    return null;
                }
                throw new IllegalArgumentException("intermediate property '" + tokens[i] + "' is null");
            }
            accessor = new DirectFieldAccessor(value);
        }
        return value;
    }

    public static <T> T getPropertyValue(Object root, String propertyPath, Class<T> type) {
        Object value = KafkaTestUtils.getPropertyValue(root, propertyPath);
        if (value != null) {
            Assert.isAssignable(type, value.getClass());
        }
        return (T)value;
    }
}

