/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Element;

public class XPathExpressionParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        return XPathExpressionFactory.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String expression = element.getAttribute("expression");
        Assert.hasText((String)expression, (String)"The 'expression' attribute is required.");
        builder.setFactoryMethod("createXPathExpression");
        builder.addConstructorArgValue((Object)expression);
        XPathExpressionParser.parseAndPopulateNamespaceMap(element, parserContext, builder);
    }

    static void parseAndPopulateNamespaceMap(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element mapElement;
        boolean mapSubElementProvided;
        String nsPrefix = element.getAttribute("ns-prefix");
        String nsUri = element.getAttribute("ns-uri");
        String namespaceMapRef = element.getAttribute("namespace-map");
        List mapElements = DomUtils.getChildElementsByTagName((Element)element, (String)"map");
        boolean prefixProvided = StringUtils.hasText((String)nsPrefix);
        boolean namespaceProvided = StringUtils.hasText((String)nsUri);
        boolean namespaceMapProvided = StringUtils.hasText((String)namespaceMapRef);
        boolean bl = mapSubElementProvided = !mapElements.isEmpty();
        if (prefixProvided || namespaceProvided) {
            Assert.isTrue((prefixProvided && namespaceProvided ? 1 : 0) != 0, (String)"Both 'ns-prefix' and 'ns-uri' must be specified if one is specified.");
            Assert.isTrue((!namespaceMapProvided ? 1 : 0) != 0, (String)"It is not valid to specify both, the namespace attributes ('ns-prefix' and 'ns-uri') and the 'namespace-map' attribute.");
            Assert.isTrue((!mapSubElementProvided ? 1 : 0) != 0, (String)"It is not valid to specify both, the namespace attributes ('ns-prefix' and 'ns-uri') and the 'map' sub-element.");
        } else if (mapSubElementProvided) {
            Assert.isTrue((!namespaceMapProvided ? 1 : 0) != 0, (String)"It is not valid to specify both, the 'namespace-map' attribute and the 'map' sub-element.");
        }
        if (prefixProvided) {
            HashMap<String, String> namespaceMap = new HashMap<String, String>(1);
            namespaceMap.put(nsPrefix, nsUri);
            builder.addConstructorArgValue(namespaceMap);
        } else if (namespaceMapProvided) {
            builder.addConstructorArgReference(namespaceMapRef);
        } else if (mapSubElementProvided && (mapElement = (Element)mapElements.get(0)) != null) {
            BeanDefinitionParserDelegate beanParser = parserContext.getDelegate();
            beanParser.initDefaults(mapElement.getOwnerDocument().getDocumentElement(), beanParser);
            builder.addConstructorArgValue((Object)beanParser.parseMapElement(mapElement, (BeanDefinition)builder.getRawBeanDefinition()));
        }
    }
}

