/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.integration.xml.source.DomSourceFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.support.MarshallingUtils;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class UnmarshallingTransformer
extends AbstractPayloadTransformer<Object, Object> {
    private final Unmarshaller unmarshaller;
    private volatile SourceFactory sourceFactory = new DomSourceFactory();
    private volatile boolean alwaysUseSourceFactory = false;
    private MimeMessageUnmarshallerHelper mimeMessageUnmarshallerHelper;

    public UnmarshallingTransformer(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
        if (ClassUtils.isPresent((String)"org.springframework.ws.mime.MimeMessage", (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            this.mimeMessageUnmarshallerHelper = new MimeMessageUnmarshallerHelper(unmarshaller);
        }
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        Assert.notNull((Object)sourceFactory, (String)"sourceFactory must not be null");
        this.sourceFactory = sourceFactory;
    }

    public void setAlwaysUseSourceFactory(boolean alwaysUseSourceFactory) {
        this.alwaysUseSourceFactory = alwaysUseSourceFactory;
    }

    public String getComponentType() {
        return "xml:unmarshalling-transformer";
    }

    public Object transformPayload(Object payload) {
        try {
            Object result;
            if (this.mimeMessageUnmarshallerHelper != null && (result = this.mimeMessageUnmarshallerHelper.maybeUnmarshalMimeMessage(payload)) != null) {
                return result;
            }
            Object source = this.alwaysUseSourceFactory ? this.sourceFactory.createSource(payload) : (payload instanceof String ? new StringSource((String)payload) : (payload instanceof byte[] ? new StreamSource(new ByteArrayInputStream((byte[])payload)) : (payload instanceof File ? new StreamSource((File)payload) : (payload instanceof Document ? new DOMSource((Document)payload) : (payload instanceof Source ? (Source)payload : this.sourceFactory.createSource(payload))))));
            Assert.state((source != null ? 1 : 0) != 0, () -> "failed to transform message, payload not assignable from " + Source.class.getName() + "and no conversion possible");
            return this.unmarshaller.unmarshal((Source)source);
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to unmarshal payload", e);
        }
    }

    private static class MimeMessageUnmarshallerHelper {
        private final Unmarshaller delegate;

        MimeMessageUnmarshallerHelper(Unmarshaller unmarshaller) {
            this.delegate = unmarshaller;
        }

        Object maybeUnmarshalMimeMessage(Object payload) throws IOException {
            if (payload instanceof MimeMessage) {
                return MarshallingUtils.unmarshal((Unmarshaller)this.delegate, (WebServiceMessage)((MimeMessage)payload));
            }
            return null;
        }
    }
}

