/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXPathMessageSelector
implements MessageSelector {
    private final XPathExpression xPathExpresion;
    private volatile XmlPayloadConverter converter = new DefaultXmlPayloadConverter();

    public AbstractXPathMessageSelector(String xPathExpression) {
        this.xPathExpresion = XPathExpressionFactory.createXPathExpression((String)xPathExpression);
    }

    public AbstractXPathMessageSelector(String xPathExpression, String prefix, String namespace) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(prefix, namespace);
        this.xPathExpresion = XPathExpressionFactory.createXPathExpression((String)xPathExpression, namespaces);
    }

    public AbstractXPathMessageSelector(String xPathExpression, Map<String, String> namespaces) {
        this.xPathExpresion = XPathExpressionFactory.createXPathExpression((String)xPathExpression, namespaces);
    }

    public AbstractXPathMessageSelector(XPathExpression xPathExpression) {
        this.xPathExpresion = xPathExpression;
    }

    public void setConverter(XmlPayloadConverter converter) {
        this.converter = converter;
    }

    protected XmlPayloadConverter getConverter() {
        return this.converter;
    }

    protected XPathExpression getXPathExpresion() {
        return this.xPathExpresion;
    }
}

