/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.integration.MessagingException;
import org.springframework.integration.xml.transformer.ResultTransformer;
import org.springframework.xml.transform.StringResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ResultToDocumentTransformer
implements ResultTransformer {
    private final DocumentBuilderFactory documentBuilderFactory;

    public ResultToDocumentTransformer(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public ResultToDocumentTransformer() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public Object transformResult(Result result) {
        Document document = null;
        if (DOMResult.class.isAssignableFrom(result.getClass())) {
            document = this.createDocumentFromDomResult((DOMResult)result);
        } else if (StringResult.class.isAssignableFrom(result.getClass())) {
            document = this.createDocumentFromStringResult((StringResult)result);
        } else {
            throw new MessagingException("failed to create document from payload type [" + result.getClass().getName() + "]");
        }
        return document;
    }

    private Document createDocumentFromDomResult(DOMResult domResult) {
        return (Document)domResult.getNode();
    }

    private Document createDocumentFromStringResult(StringResult stringResult) {
        try {
            return this.getDocumentBuilder().parse(new InputSource(new StringReader(stringResult.toString())));
        }
        catch (Exception e) {
            throw new MessagingException("failed to create Document from StringResult payload", (Throwable)e);
        }
    }

    private synchronized DocumentBuilder getDocumentBuilder() {
        try {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("failed to create a new DocumentBuilder", (Throwable)e);
        }
    }
}

