/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.ServiceUnavailableException;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapMessage;

public abstract class AbstractWebServiceInboundGateway
extends MessagingGatewaySupport
implements MessageEndpoint,
OrderlyShutdownCapable {
    private final AtomicInteger activeCount = new AtomicInteger();
    private SoapHeaderMapper headerMapper = new DefaultSoapHeaderMapper();

    public String getComponentType() {
        return "ws:inbound-gateway";
    }

    public void setHeaderMapper(SoapHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    protected SoapHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void invoke(MessageContext messageContext) throws Exception {
        if (!this.isRunning()) {
            throw new ServiceUnavailableException("503 Service Unavailable");
        }
        Assert.notNull((Object)messageContext, (String)"'messageContext' is required; it must not be null.");
        try {
            this.activeCount.incrementAndGet();
            this.doInvoke(messageContext);
        }
        catch (Exception e) {
            while ((e instanceof MessagingException || e instanceof ExpressionException) && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
        finally {
            this.activeCount.decrementAndGet();
        }
    }

    protected void fromSoapHeaders(MessageContext messageContext, AbstractIntegrationMessageBuilder<?> builder) {
        SoapMessage soapMessage;
        Map headers;
        WebServiceMessage request = messageContext.getRequest();
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                builder.setHeader(propertyName, messageContext.getProperty(propertyName));
            }
        }
        if (request instanceof SoapMessage && !CollectionUtils.isEmpty((Map)(headers = this.headerMapper.toHeadersFromRequest(soapMessage = (SoapMessage)request)))) {
            builder.copyHeaders(headers);
        }
    }

    protected void toSoapHeaders(WebServiceMessage response, Message<?> replyMessage) {
        if (response instanceof SoapMessage) {
            this.headerMapper.fromHeadersToReply(replyMessage.getHeaders(), (SoapMessage)response);
        }
    }

    public int beforeShutdown() {
        this.stop();
        return this.activeCount.get();
    }

    public int afterShutdown() {
        return this.activeCount.get();
    }

    protected abstract void doInvoke(MessageContext var1) throws IOException;
}

