/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.util.JavaUtils;
import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public abstract class BaseWsOutboundGatewaySpec<S extends BaseWsOutboundGatewaySpec<S, E>, E extends AbstractWebServiceOutboundGateway>
extends MessageHandlerSpec<S, E> {
    private final Map<String, Expression> uriVariableExpressions = new HashMap<String, Expression>();
    protected WebServiceTemplate template;
    protected DestinationProvider destinationProvider;
    protected String uri;
    protected WebServiceMessageFactory webServiceMessageFactory;
    private SoapHeaderMapper headerMapper;
    private DefaultUriBuilderFactory.EncodingMode encodingMode;
    private boolean ignoreEmptyResponses = true;
    private WebServiceMessageCallback requestCallback;
    protected FaultMessageResolver faultMessageResolver;
    protected WebServiceMessageSender[] messageSenders;
    protected ClientInterceptor[] gatewayInterceptors;
    protected boolean extractPayload = true;

    public S destinationProvider(DestinationProvider destinationProvider) {
        this.destinationProvider = destinationProvider;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S uri(String uri) {
        this.uri = uri;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S headerMapper(SoapHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S uriVariableExpressions(Map<String, Expression> uriVariableExpressions) {
        this.uriVariableExpressions.putAll(uriVariableExpressions);
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S encodingMode(DefaultUriBuilderFactory.EncodingMode encodingMode) {
        this.encodingMode = encodingMode;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S ignoreEmptyResponses(boolean ignoreEmptyResponses) {
        this.ignoreEmptyResponses = ignoreEmptyResponses;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    public S requestCallback(WebServiceMessageCallback requestCallback) {
        this.requestCallback = requestCallback;
        return (S)((Object)((BaseWsOutboundGatewaySpec)this._this()));
    }

    protected E doGet() {
        return this.assemble(this.create());
    }

    protected abstract E create();

    protected E assemble(E gateway) {
        ((AbstractWebServiceOutboundGateway)((Object)gateway)).setUriVariableExpressions(this.uriVariableExpressions);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.headerMapper, arg_0 -> gateway.setHeaderMapper(arg_0)).acceptIfNotNull((Object)this.encodingMode, arg_0 -> gateway.setEncodingMode(arg_0));
        ((AbstractWebServiceOutboundGateway)((Object)gateway)).setIgnoreEmptyResponses(this.ignoreEmptyResponses);
        ((AbstractWebServiceOutboundGateway)((Object)gateway)).setRequestCallback(this.requestCallback);
        return gateway;
    }
}

