/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import org.springframework.integration.Message;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.ws.AbstractWebServiceInboundGateway;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.support.MarshallingUtils;

public class MarshallingWebServiceInboundGateway
extends AbstractWebServiceInboundGateway {
    private volatile Marshaller marshaller;
    private volatile Unmarshaller unmarshaller;

    public MarshallingWebServiceInboundGateway() {
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must no be null");
        Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller, (String)"When using this constructor the provided Marshaller must also implement Unmarshaller");
        this.marshaller = marshaller;
        this.unmarshaller = (Unmarshaller)marshaller;
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must no be null");
        Assert.notNull((Object)unmarshaller, (String)"'unmarshaller' must no be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must no be null");
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"'unmarshaller' must no be null");
        this.unmarshaller = unmarshaller;
    }

    protected void onInit() throws Exception {
        super.onInit();
        Assert.notNull((Object)this.marshaller, (String)"This implementation requires Marshaller");
        Assert.notNull((Object)this.unmarshaller, (String)"This implementation requires Unmarshaller");
    }

    @Override
    protected void doInvoke(MessageContext messageContext) throws Exception {
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        Object requestObject = MarshallingUtils.unmarshal((Unmarshaller)this.unmarshaller, (WebServiceMessage)request);
        MessageBuilder builder = MessageBuilder.withPayload((Object)requestObject);
        this.fromSoapHeaders(messageContext, builder);
        Message replyMessage = this.sendAndReceiveMessage(builder.build());
        if (replyMessage != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.toSoapHeaders(response, replyMessage);
            MarshallingUtils.marshal((Marshaller)this.marshaller, (Object)replyMessage.getPayload(), (WebServiceMessage)response);
        }
    }
}

