/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.xml.namespace.QNameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSoapHeaderMapper
implements HeaderMapper<SoapHeader> {
    private volatile String[] outboundHeaderNames = new String[0];
    private volatile String[] inboundHeaderNames = new String[]{"*"};

    public void setOutboundHeaderNames(String[] outboundHeaderNames) {
        this.outboundHeaderNames = outboundHeaderNames != null ? outboundHeaderNames : new String[]{};
    }

    public void setInboundHeaderNames(String[] inboundHeaderNames) {
        this.inboundHeaderNames = inboundHeaderNames != null ? inboundHeaderNames : new String[]{};
    }

    public void fromHeaders(MessageHeaders headers, SoapHeader target) {
        if (target != null && !CollectionUtils.isEmpty((Map)headers)) {
            for (String headerName : headers.keySet()) {
                Object value;
                if (!this.shouldMapOutboundHeader(headerName) || !((value = headers.get((Object)headerName)) instanceof String)) continue;
                QName qname = QNameUtils.parseQNameString((String)headerName);
                target.addAttribute(qname, (String)value);
            }
        }
    }

    public Map<String, Object> toHeaders(SoapHeader source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (source != null) {
            Iterator attributeIter = source.getAllAttributes();
            while (attributeIter.hasNext()) {
                String value;
                String qnameString;
                Object name = attributeIter.next();
                if (!(name instanceof QName) || !this.shouldMapInboundHeader(qnameString = QNameUtils.toQualifiedName((QName)((QName)name))) || (value = source.getAttributeValue((QName)name)) == null) continue;
                headers.put(qnameString, value);
            }
            Iterator elementIter = source.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                QName qname;
                String qnameString;
                Object element = elementIter.next();
                if (!(element instanceof SoapHeaderElement) || !this.shouldMapInboundHeader(qnameString = QNameUtils.toQualifiedName((QName)(qname = ((SoapHeaderElement)element).getName())))) continue;
                headers.put(qnameString, element);
            }
        }
        return headers;
    }

    private boolean shouldMapInboundHeader(String headerName) {
        return DefaultSoapHeaderMapper.matchesAny(this.inboundHeaderNames, headerName);
    }

    private boolean shouldMapOutboundHeader(String headerName) {
        return DefaultSoapHeaderMapper.matchesAny(this.outboundHeaderNames, headerName);
    }

    private static boolean matchesAny(String[] patterns, String candidate) {
        if (!ObjectUtils.isEmpty((Object[])patterns) && QNameUtils.validateQName((String)candidate)) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)candidate)) continue;
                return true;
            }
        }
        return false;
    }
}

