/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.history.TrackableComponent;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.ws.server.endpoint.AbstractMarshallingPayloadEndpoint;

public class MarshallingWebServiceInboundGateway
extends AbstractMarshallingPayloadEndpoint
implements BeanNameAware,
BeanFactoryAware,
InitializingBean,
SmartLifecycle,
TrackableComponent {
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private final GatewayDelegate gatewayDelegate = new GatewayDelegate();
    private volatile int phase = 0;

    public MarshallingWebServiceInboundGateway() {
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller) {
        super(marshaller);
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller, Unmarshaller unmarshaller) {
        super(marshaller, unmarshaller);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        this.gatewayDelegate.setRequestChannel(requestChannel);
    }

    public void setRequestTimeout(long requestTimeout) {
        this.gatewayDelegate.setRequestTimeout(requestTimeout);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.gatewayDelegate.setReplyChannel(replyChannel);
    }

    public void setReplyTimeout(long replyTimeout) {
        this.gatewayDelegate.setReplyTimeout(replyTimeout);
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.gatewayDelegate.setTaskScheduler(taskScheduler);
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.gatewayDelegate.setShouldTrack(shouldTrack);
    }

    public String getComponentName() {
        return this.gatewayDelegate.getComponentName();
    }

    public String getComponentType() {
        return this.gatewayDelegate.getComponentType();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.gatewayDelegate.setAutoStartup(autoStartup);
    }

    public boolean isAutoStartup() {
        return this.gatewayDelegate.isAutoStartup();
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String beanName) {
        this.gatewayDelegate.setBeanName(beanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.gatewayDelegate.setBeanFactory(beanFactory);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.gatewayDelegate.afterPropertiesSet();
    }

    protected Object invokeInternal(Object requestObject) throws Exception {
        try {
            return this.gatewayDelegate.sendAndReceive(requestObject);
        }
        catch (Exception e) {
            while ((e instanceof MessagingException || e instanceof ExpressionException) && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.gatewayDelegate.isRunning();
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.gatewayDelegate.isRunning()) {
                this.gatewayDelegate.start();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("started " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.gatewayDelegate.isRunning()) {
                this.gatewayDelegate.stop();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("stopped " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private static class GatewayDelegate
    extends MessagingGatewaySupport {
        private GatewayDelegate() {
        }

        public Object sendAndReceive(Object request) {
            return super.sendAndReceive(request);
        }

        public String getComponentType() {
            return "ws:outbound-gateway";
        }
    }
}

