/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.webflux.inbound.IntegrationHandlerResultHandler;
import org.springframework.integration.webflux.inbound.WebFluxIntegrationRequestMappingHandlerMapping;

public class WebFluxIntegrationConfigurationInitializer
implements IntegrationConfigurationInitializer {
    private static final Log LOGGER = LogFactory.getLog(WebFluxIntegrationConfigurationInitializer.class);

    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
            this.registerReactiveRequestMappingHandlerMappingIfNecessary(beanDefinitionRegistry);
        } else {
            LOGGER.warn((Object)"'IntegrationRequestMappingHandlerMapping' isn't registered because 'beanFactory' isn't an instance of `BeanDefinitionRegistry`.");
        }
    }

    private void registerReactiveRequestMappingHandlerMappingIfNecessary(BeanDefinitionRegistry registry) {
        if (HttpContextUtils.WEB_FLUX_PRESENT && !registry.containsBeanDefinition("webFluxIntegrationRequestMappingHandlerMapping")) {
            BeanDefinitionBuilder requestMappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(WebFluxIntegrationRequestMappingHandlerMapping.class).addPropertyValue("order", (Object)0).setRole(2);
            registry.registerBeanDefinition("webFluxIntegrationRequestMappingHandlerMapping", (BeanDefinition)requestMappingBuilder.getBeanDefinition());
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)new RootBeanDefinition(IntegrationHandlerResultHandler.class), (BeanDefinitionRegistry)registry);
        }
    }
}

