/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.outbound;

import java.net.URI;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFluxRequestExecutingMessageHandler
extends AbstractHttpRequestExecutingMessageHandler {
    private static final String UNCHECKED = "unchecked";
    private final WebClient webClient;
    private final boolean webClientExplicitlySet;
    private boolean replyPayloadToFlux;
    private BodyExtractor<?, ? super ClientHttpResponse> bodyExtractor;
    private Expression publisherElementTypeExpression;
    private Expression attributeVariablesExpression;
    private StandardEvaluationContext evaluationContext;

    public WebFluxRequestExecutingMessageHandler(URI uri) {
        this((Expression)new ValueExpression((Object)uri));
    }

    public WebFluxRequestExecutingMessageHandler(String uri) {
        this(uri, null);
    }

    public WebFluxRequestExecutingMessageHandler(Expression uriExpression) {
        this(uriExpression, null);
    }

    public WebFluxRequestExecutingMessageHandler(String uri, @Nullable WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
        Assert.hasText((String)uri, (String)"URI is required");
    }

    public WebFluxRequestExecutingMessageHandler(Expression uriExpression, @Nullable WebClient webClient) {
        super(uriExpression);
        this.webClientExplicitlySet = webClient != null;
        this.webClient = !this.webClientExplicitlySet ? WebClient.builder().uriBuilderFactory((UriBuilderFactory)this.uriFactory).build() : webClient;
        this.setAsync(true);
    }

    private void assertLocalWebClient(String option) {
        Assert.isTrue((!this.webClientExplicitlySet ? 1 : 0) != 0, () -> "The option '" + option + "' must be provided on the externally configured WebClient: " + String.valueOf(this.webClient));
    }

    public void setEncodingMode(DefaultUriBuilderFactory.EncodingMode encodingMode) {
        this.assertLocalWebClient("encodingMode on UriBuilderFactory");
        super.setEncodingMode(encodingMode);
    }

    public void setReplyPayloadToFlux(boolean replyPayloadToFlux) {
        this.replyPayloadToFlux = replyPayloadToFlux;
    }

    public void setBodyExtractor(BodyExtractor<?, ? super ClientHttpResponse> bodyExtractor) {
        this.bodyExtractor = bodyExtractor;
    }

    public void setPublisherElementType(Class<?> publisherElementType) {
        Assert.notNull(publisherElementType, (String)"'publisherElementType' must not be null");
        this.setPublisherElementTypeExpression((Expression)new ValueExpression(publisherElementType));
    }

    public void setPublisherElementTypeExpression(Expression publisherElementTypeExpression) {
        this.publisherElementTypeExpression = publisherElementTypeExpression;
    }

    public void setAttributeVariablesExpression(Expression attributeVariablesExpression) {
        Assert.notNull((Object)attributeVariablesExpression, (String)"'attributeVariablesExpression' must not be null");
        this.attributeVariablesExpression = attributeVariablesExpression;
    }

    public String getComponentType() {
        return this.isExpectReply() ? "webflux:outbound-gateway" : "webflux:outbound-channel-adapter";
    }

    protected final void doInit() {
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    @Nullable
    protected Object exchange(Object uri, HttpMethod httpMethod, HttpEntity<?> httpRequest, Object expectedResponseType, Message<?> requestMessage, Map<String, ?> uriVariables) {
        WebClient.RequestBodySpec requestSpec = this.createRequestBodySpec(uri, httpMethod, httpRequest, requestMessage, uriVariables);
        Mono<ResponseEntity<Flux<Object>>> responseMono = this.exchangeForResponseMono(requestSpec, expectedResponseType);
        if (this.isExpectReply()) {
            return this.createReplyFromResponse(responseMono);
        }
        return responseMono.then();
    }

    private WebClient.RequestBodySpec createRequestBodySpec(Object uri, HttpMethod httpMethod, HttpEntity<?> httpRequest, Message<?> requestMessage, Map<String, ?> uriVariables) {
        BodyInserter<?, ? super ClientHttpRequest> inserter;
        Map<String, Object> attributeMap;
        WebClient.RequestBodySpec requestSpec;
        WebClient.RequestBodyUriSpec requestBodyUriSpec = this.webClient.method(httpMethod);
        if (uri instanceof URI) {
            URI castUri = (URI)uri;
            requestSpec = (WebClient.RequestBodySpec)requestBodyUriSpec.uri(castUri);
        } else {
            requestSpec = (WebClient.RequestBodySpec)requestBodyUriSpec.uri((String)uri, uriVariables);
        }
        requestSpec = (WebClient.RequestBodySpec)requestSpec.headers(headers -> headers.putAll((Map)httpRequest.getHeaders()));
        if (this.attributeVariablesExpression != null && !CollectionUtils.isEmpty(attributeMap = this.evaluateAttributeVariables(requestMessage))) {
            requestSpec = (WebClient.RequestBodySpec)requestSpec.attributes(map -> map.putAll(attributeMap));
        }
        if ((inserter = this.buildBodyInserterForRequest(requestMessage, httpRequest)) != null) {
            requestSpec.body(inserter);
        }
        return requestSpec;
    }

    private Map<String, Object> evaluateAttributeVariables(Message<?> requestMessage) {
        return (Map)this.attributeVariablesExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, Map.class);
    }

    @Nullable
    private BodyInserter<?, ? super ClientHttpRequest> buildBodyInserterForRequest(Message<?> requestMessage, HttpEntity<?> httpRequest) {
        BodyInserter<Publisher, ClientHttpRequest> inserter;
        Object requestBody = httpRequest.getBody();
        if (requestBody == null) {
            return null;
        }
        if (requestBody instanceof Resource) {
            Resource resource = (Resource)requestBody;
            inserter = BodyInserters.fromResource((Resource)resource);
        } else if (requestBody instanceof Publisher) {
            Publisher publisher = (Publisher)requestBody;
            inserter = this.buildBodyInserterForPublisher(requestMessage, publisher);
        } else if (requestBody instanceof MultiValueMap) {
            MultiValueMap multiValueMap = (MultiValueMap)requestBody;
            inserter = WebFluxRequestExecutingMessageHandler.buildBodyInserterForMultiValueMap(multiValueMap, httpRequest.getHeaders().getContentType());
        } else {
            inserter = BodyInserters.fromValue((Object)requestBody);
        }
        return inserter;
    }

    private <T, P extends Publisher<T>> BodyInserter<P, ? super ClientHttpRequest> buildBodyInserterForPublisher(Message<?> requestMessage, P publisher) {
        Object publisherElementType = this.evaluateTypeFromExpression(requestMessage, this.publisherElementTypeExpression, "publisherElementType");
        BodyInserter inserter = publisherElementType instanceof Class ? BodyInserters.fromPublisher(publisher, (Class)((Class)publisherElementType)) : (publisherElementType instanceof ParameterizedTypeReference ? BodyInserters.fromPublisher(publisher, (ParameterizedTypeReference)((ParameterizedTypeReference)publisherElementType)) : BodyInserters.fromPublisher(publisher, Object.class));
        return inserter;
    }

    @Nullable
    private static BodyInserters.FormInserter<?> buildBodyInserterForMultiValueMap(MultiValueMap<?, ?> requestBody, MediaType contentType) {
        if (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)contentType)) {
            return BodyInserters.fromFormData(requestBody);
        }
        if (MediaType.MULTIPART_FORM_DATA.equals((Object)contentType)) {
            return BodyInserters.fromMultipartData(requestBody);
        }
        return null;
    }

    private Mono<ResponseEntity<Flux<Object>>> exchangeForResponseMono(WebClient.RequestBodySpec requestSpec, Object expectedResponseType) {
        return requestSpec.retrieve().onStatus(HttpStatusCode::isError, ClientResponse::createException).toEntityFlux(this.createBodyExtractor(expectedResponseType));
    }

    private BodyExtractor<Flux<Object>, ? super ClientHttpResponse> createBodyExtractor(Object expectedResponseType) {
        if (expectedResponseType != null) {
            BodyExtractor monoExtractor;
            if (this.replyPayloadToFlux) {
                if (expectedResponseType instanceof ParameterizedTypeReference) {
                    ParameterizedTypeReference parameterizedTypeReference = (ParameterizedTypeReference)expectedResponseType;
                    return BodyExtractors.toFlux((ParameterizedTypeReference)parameterizedTypeReference);
                }
                return BodyExtractors.toFlux((Class)((Class)expectedResponseType));
            }
            if (expectedResponseType instanceof ParameterizedTypeReference) {
                ParameterizedTypeReference parameterizedTypeReference = (ParameterizedTypeReference)expectedResponseType;
                monoExtractor = BodyExtractors.toMono((ParameterizedTypeReference)parameterizedTypeReference);
            } else {
                monoExtractor = BodyExtractors.toMono((Class)((Class)expectedResponseType));
            }
            return (inputMessage, context) -> Flux.from((Publisher)((Publisher)monoExtractor.extract(inputMessage, context)));
        }
        if (this.bodyExtractor != null) {
            return (inputMessage, context) -> {
                Object body = this.bodyExtractor.extract(inputMessage, context);
                if (body instanceof Publisher) {
                    Publisher publisher = (Publisher)body;
                    return Flux.from((Publisher)publisher);
                }
                return Flux.just((Object)body);
            };
        }
        return (inputMessage, context) -> Flux.empty();
    }

    private Object createReplyFromResponse(Mono<ResponseEntity<Flux<Object>>> responseMono) {
        return responseMono.flatMap(response -> {
            ResponseEntity.BodyBuilder httpEntityBuilder = (ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)response.getStatusCode()).headers(response.getHeaders());
            Flux body = (Flux)response.getBody();
            Mono bodyMono = Mono.empty();
            if (body != null) {
                bodyMono = this.replyPayloadToFlux ? Mono.just((Object)body) : body.next();
            }
            return bodyMono.map(arg_0 -> ((ResponseEntity.BodyBuilder)httpEntityBuilder).body(arg_0)).defaultIfEmpty((Object)httpEntityBuilder.build());
        }).map(x$0 -> this.getReply((ResponseEntity)x$0));
    }
}

