/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.http.config.HttpOutboundChannelAdapterParser;
import org.springframework.integration.webflux.outbound.WebFluxRequestExecutingMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class WebFluxOutboundChannelAdapterParser
extends HttpOutboundChannelAdapterParser {
    protected BeanDefinitionBuilder getBuilder(Element element, ParserContext parserContext) {
        return WebFluxOutboundChannelAdapterParser.buildWebFluxRequestExecutingMessageHandler(element, parserContext);
    }

    static BeanDefinitionBuilder buildWebFluxRequestExecutingMessageHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(WebFluxRequestExecutingMessageHandler.class);
        String webClientRef = element.getAttribute("web-client");
        if (StringUtils.hasText((String)webClientRef)) {
            if (element.hasAttribute("encoding-mode")) {
                parserContext.getReaderContext().error("The 'web-client' and 'encoding-mode' attributes are mutually exclusive.", (Object)element);
            }
            builder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(webClientRef));
        } else {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encoding-mode");
        }
        String type = element.getAttribute("publisher-element-type");
        String typeExpression = element.getAttribute("publisher-element-type-expression");
        boolean hasType = StringUtils.hasText((String)type);
        boolean hasTypeExpression = StringUtils.hasText((String)typeExpression);
        if (hasType && hasTypeExpression) {
            parserContext.getReaderContext().error("The 'publisher-element-type' and 'publisher-element-type-expression' attributes are mutually exclusive.", (Object)element);
        }
        if (hasType) {
            builder.addPropertyValue("publisherElementType", (Object)type);
        } else if (hasTypeExpression) {
            builder.addPropertyValue("publisherElementTypeExpression", (Object)BeanDefinitionBuilder.rootBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)typeExpression).getBeanDefinition());
        }
        BeanDefinition attributeVariablesExpressionDef = IntegrationNamespaceUtils.createExpressionDefIfAttributeDefined((String)"attribute-variables-expression", (Element)element);
        if (attributeVariablesExpressionDef != null) {
            builder.addPropertyValue("attributeVariablesExpression", (Object)attributeVariablesExpressionDef);
        }
        return builder;
    }
}

