/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.util.Assert;

public class DirectMessageSendingMessageHandler
extends AbstractMessageHandler {
    private final Twitter twitter;

    public DirectMessageSendingMessageHandler(Twitter twitter) {
        Assert.notNull((Object)twitter, (String)"twitter must not be null");
        this.twitter = twitter;
    }

    public String getComponentType() {
        return "twitter:dm-outbound-channel-adapter";
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Assert.isTrue((boolean)(message.getPayload() instanceof String), (String)"Only payload of type String is supported. Consider adding a transformer to the message flow in front of this adapter.");
        Object toUser = message.getHeaders().get((Object)"twitter_dmTargetUserId");
        Assert.isTrue((toUser instanceof String || toUser instanceof Number ? 1 : 0) != 0, (String)"the header 'twitter_dmTargetUserId' must contain either a String (a screenname) or an number (a user ID)");
        String payload = (String)message.getPayload();
        if (toUser instanceof Number) {
            this.twitter.directMessageOperations().sendDirectMessage(((Number)toUser).longValue(), payload);
        } else if (toUser instanceof String) {
            this.twitter.directMessageOperations().sendDirectMessage((String)toUser, payload);
        }
    }
}

