/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TweetData;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.util.Assert;

public class StatusUpdatingMessageHandler
extends AbstractMessageHandler
implements IntegrationEvaluationContextAware {
    private final Twitter twitter;
    private volatile Expression tweetDataExpression;
    private EvaluationContext evaluationContext;

    public StatusUpdatingMessageHandler(Twitter twitter) {
        Assert.notNull((Object)twitter, (String)"twitter must not be null");
        this.twitter = twitter;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        TypeLocator typeLocator = evaluationContext.getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            ((StandardTypeLocator)typeLocator).registerImport("org.springframework.social.twitter.api");
        }
        this.evaluationContext = evaluationContext;
    }

    public String getComponentType() {
        return "twitter:outbound-channel-adapter";
    }

    public void setTweetDataExpression(Expression tweetDataExpression) {
        this.tweetDataExpression = tweetDataExpression;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object value = this.tweetDataExpression != null ? this.tweetDataExpression.getValue(this.evaluationContext, message) : message.getPayload();
        Assert.notNull((Object)value, (String)"The tweetData cannot evaluate to 'null'.");
        TweetData tweetData = null;
        if (value instanceof TweetData) {
            tweetData = (TweetData)value;
        } else if (value instanceof Tweet) {
            tweetData = new TweetData(((Tweet)value).getText());
        } else if (value instanceof String) {
            tweetData = new TweetData((String)value);
        } else {
            throw new MessageHandlingException(message, "Unsupported tweetData: " + value);
        }
        this.twitter.timelineOperations().updateStatus(tweetData);
    }
}

