/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.inbound;

import java.util.Collections;
import java.util.List;
import org.springframework.integration.twitter.inbound.AbstractTwitterMessageSource;
import org.springframework.social.twitter.api.SearchResults;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.social.twitter.api.impl.SearchParameters;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchReceivingMessageSource
extends AbstractTwitterMessageSource<Tweet> {
    private volatile String query;

    public SearchReceivingMessageSource(Twitter twitter) {
        super(twitter);
    }

    public void setQuery(String query) {
        Assert.hasText((String)query, (String)"'query' must not be null");
        this.query = query;
    }

    public String getComponentType() {
        return "twitter:search-inbound-channel-adapter";
    }

    @Override
    protected List<Tweet> pollForTweets(long sinceId) {
        SearchParameters searchParameters = new SearchParameters(this.query).count(20).sinceId(sinceId);
        SearchResults results = this.getTwitter().searchOperations().search(searchParameters);
        return results != null ? results.getTweets() : Collections.emptyList();
    }
}

