/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.core;

import java.util.LinkedList;
import java.util.List;
import org.springframework.integration.twitter.core.SearchResults;
import org.springframework.integration.twitter.core.Tweet;
import org.springframework.integration.twitter.core.TwitterOperationException;
import org.springframework.integration.twitter.core.TwitterOperations;
import org.springframework.util.Assert;
import twitter4j.DirectMessage;
import twitter4j.Paging;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.http.AccessToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter4jTemplate
implements TwitterOperations {
    private final Twitter twitter;

    public Twitter4jTemplate() {
        this.twitter = new TwitterFactory().getInstance();
    }

    public Twitter4jTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        Assert.hasText((String)consumerKey, (String)"'consumerKey' must be provided");
        Assert.hasText((String)consumerSecret, (String)"'consumerSecret' must be provided");
        Assert.hasText((String)accessToken, (String)"'accessToken' must be provided");
        Assert.hasText((String)accessTokenSecret, (String)"'accessTokenSecret' must be provided");
        AccessToken token = new AccessToken(accessToken, accessTokenSecret);
        this.twitter = new TwitterFactory().getOAuthAuthorizedInstance(consumerKey, consumerSecret, token);
    }

    @Override
    public String getProfileId() {
        try {
            if (this.twitter.isOAuthEnabled()) {
                return this.twitter.getScreenName();
            }
            return "twitter-anonymous";
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to obtain Profile ID. ", e);
        }
    }

    @Override
    public List<Tweet> getDirectMessages() {
        try {
            ResponseList directMessages = this.twitter.getDirectMessages();
            return this.buildTweetsFromTwitterResponses((List<?>)directMessages);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Direct Messages. ", e);
        }
    }

    @Override
    public List<Tweet> getDirectMessages(long sinceId) {
        try {
            ResponseList directMessages = this.twitter.getDirectMessages(new Paging(sinceId));
            return this.buildTweetsFromTwitterResponses((List<?>)directMessages);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Direct Messages since the last message with ID: " + sinceId + ".", e);
        }
    }

    @Override
    public List<Tweet> getMentions() {
        try {
            ResponseList mentions = this.twitter.getMentions();
            return this.buildTweetsFromTwitterResponses((List<?>)mentions);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Mention statuses. ", e);
        }
    }

    @Override
    public List<Tweet> getMentions(long sinceId) {
        try {
            ResponseList mentions = this.twitter.getMentions(new Paging(sinceId));
            return this.buildTweetsFromTwitterResponses((List<?>)mentions);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Mention statuses since the last status with ID: " + sinceId + ".", e);
        }
    }

    @Override
    public List<Tweet> getTimeline() {
        try {
            ResponseList timelines = this.twitter.getHomeTimeline();
            return this.buildTweetsFromTwitterResponses((List<?>)timelines);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Timeline statuses. ", e);
        }
    }

    @Override
    public List<Tweet> getTimeline(long sinceId) {
        try {
            ResponseList timelines = this.twitter.getHomeTimeline(new Paging(sinceId));
            return this.buildTweetsFromTwitterResponses((List<?>)timelines);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to receive Timeline statuses since the last status with ID: " + sinceId + ".", e);
        }
    }

    @Override
    public void sendDirectMessage(String userName, String text) {
        Assert.hasText((String)userName, (String)"'userName' is required");
        Assert.hasText((String)text, (String)"'text' is required");
        try {
            this.twitter.sendDirectMessage(userName, text);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to send Direct Message to user: " + userName + ".", e);
        }
    }

    @Override
    public void sendDirectMessage(int userId, String text) {
        Assert.state((userId > 0 ? 1 : 0) != 0, (String)"'userId' is required");
        Assert.hasText((String)text, (String)"'text' is required");
        try {
            this.twitter.sendDirectMessage(userId, text);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to send Direct Message to user with id: " + userId + ".", e);
        }
    }

    @Override
    public void updateStatus(String statusTweet) {
        Assert.hasText((String)statusTweet, (String)"'statusTweet' must not be null");
        try {
            StatusUpdate status = new StatusUpdate(statusTweet);
            this.twitter.updateStatus(status);
        }
        catch (Exception e) {
            throw new TwitterOperationException("Failed to send Status update. ", e);
        }
    }

    @Override
    public SearchResults search(String query) {
        Assert.hasText((String)query, (String)"'query' must not be null");
        Query q = new Query(query);
        return this.search(q);
    }

    @Override
    public SearchResults search(String query, long sinceId) {
        Assert.hasText((String)query, (String)"'query' must not be null");
        Query q = new Query(query);
        q.setSinceId(sinceId);
        return this.search(q);
    }

    @Override
    public Twitter getUnderlyingTwitter() {
        return this.twitter;
    }

    private SearchResults search(Query query) {
        try {
            QueryResult result = this.twitter.search(query);
            if (result != null) {
                List t4jTweets = result.getTweets();
                List<Tweet> tweets = this.buildTweetsFromTwitterResponses(t4jTweets);
                SearchResults results = new SearchResults(tweets, result.getMaxId(), result.getSinceId());
                return results;
            }
        }
        catch (Exception e) {
            throw new TwitterOperationException("failed to perform Twitter search", e);
        }
        return null;
    }

    private List<Tweet> buildTweetsFromTwitterResponses(List<?> responses) {
        LinkedList<Tweet> tweets = new LinkedList<Tweet>();
        if (responses != null) {
            for (Object response : responses) {
                if (response instanceof Status) {
                    tweets.add(this.buildTweetFromStatus((Status)response));
                    continue;
                }
                if (response instanceof DirectMessage) {
                    tweets.add(this.buildTweetFromDm((DirectMessage)response));
                    continue;
                }
                if (response instanceof twitter4j.Tweet) {
                    tweets.add(this.buildTweetFromTwitter4jTweet((twitter4j.Tweet)response));
                    continue;
                }
                throw new TwitterOperationException("Unsupported response type: " + response.getClass());
            }
        }
        return tweets;
    }

    private Tweet buildTweetFromDm(DirectMessage dm) {
        Tweet tweet = new Tweet();
        tweet.setCreatedAt(dm.getCreatedAt());
        tweet.setFromUser(dm.getSenderScreenName());
        tweet.setFromUserId(dm.getSenderId());
        tweet.setId(dm.getId());
        tweet.setText(dm.getText());
        tweet.setToUserId(Long.valueOf(dm.getRecipientId()));
        return tweet;
    }

    private Tweet buildTweetFromStatus(Status status) {
        Tweet tweet = new Tweet();
        tweet.setCreatedAt(status.getCreatedAt());
        if (status.getUser() != null) {
            tweet.setFromUser(status.getUser().getScreenName());
            tweet.setFromUserId(status.getUser().getId());
        }
        tweet.setId(status.getId());
        tweet.setSource(status.getSource());
        tweet.setText(status.getText());
        return tweet;
    }

    private Tweet buildTweetFromTwitter4jTweet(twitter4j.Tweet t4jTweet) {
        Tweet tweet = new Tweet();
        tweet.setCreatedAt(t4jTweet.getCreatedAt());
        tweet.setFromUser(t4jTweet.getFromUser());
        tweet.setFromUserId(t4jTweet.getFromUserId());
        tweet.setId(t4jTweet.getId());
        tweet.setLanguageCode(t4jTweet.getIsoLanguageCode());
        tweet.setProfileImageUrl(t4jTweet.getProfileImageUrl());
        tweet.setSource(t4jTweet.getSource());
        tweet.setText(t4jTweet.getText());
        return tweet;
    }
}

