/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.twitter.core.TwitterOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessageSendingMessageHandler
extends AbstractMessageHandler {
    private final TwitterOperations twitterOperations;

    public DirectMessageSendingMessageHandler(TwitterOperations twitterOperations) {
        Assert.notNull((Object)twitterOperations, (String)"twitterOperations must not be null");
        this.twitterOperations = twitterOperations;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Assert.isInstanceOf(String.class, (Object)message.getPayload(), (String)"Only payload of type String is supported. If your payload is not of type String consider adding a transformer to the message flow in front of this adapter.");
        Assert.isTrue((boolean)message.getHeaders().containsKey((Object)"twitter_dmTargetUserId"), (String)"the 'twitter_dmTargetUserId' header is required");
        Object toUser = message.getHeaders().get((Object)"twitter_dmTargetUserId");
        Assert.isTrue((toUser instanceof String || toUser instanceof Integer ? 1 : 0) != 0, (String)"the header 'twitter_dmTargetUserId' must be either a String (a screenname) or an int (a user ID)");
        String payload = (String)message.getPayload();
        if (toUser instanceof Integer) {
            this.twitterOperations.sendDirectMessage((Integer)toUser, payload);
        } else if (toUser instanceof String) {
            this.twitterOperations.sendDirectMessage((String)toUser, payload);
        }
    }
}

