/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.twitter.config.TwitterNamespaceHandler;
import org.w3c.dom.Element;

public class TwitterOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        String className = TwitterOutboundChannelAdapterParser.determineClassName(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)className);
        builder.addConstructorArgReference(element.getAttribute("twitter-template"));
        return builder.getBeanDefinition();
    }

    private static String determineClassName(Element element, ParserContext parserContext) {
        String className = null;
        String elementName = element.getLocalName().trim();
        if ("outbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".outbound.StatusUpdatingMessageHandler";
        } else if ("dm-outbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".outbound.DirectMessageSendingMessageHandler";
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return className;
    }
}

