/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.twitter.config.TwitterNamespaceHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class TwitterInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        String className = TwitterInboundChannelAdapterParser.determineClassName(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)className);
        String templateBeanName = element.getAttribute("twitter-template");
        if (StringUtils.hasText((String)templateBeanName)) {
            builder.addConstructorArgReference(templateBeanName);
        } else {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)(TwitterNamespaceHandler.BASE_PACKAGE + ".core.Twitter4jTemplate"));
            builder.addConstructorArgValue((Object)templateBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"query");
        return builder.getBeanDefinition();
    }

    private static String determineClassName(Element element, ParserContext parserContext) {
        String className = null;
        String elementName = element.getLocalName().trim();
        if ("inbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".inbound.TimelineReceivingMessageSource";
        } else if ("dm-inbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".inbound.DirectMessageReceivingMessageSource";
        } else if ("mentions-inbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".inbound.MentionsReceivingMessageSource";
        } else if ("search-inbound-channel-adapter".equals(elementName)) {
            className = TwitterNamespaceHandler.BASE_PACKAGE + ".inbound.SearchReceivingMessageSource";
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return className;
    }
}

