/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.beans.Introspector;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.test.context.IntegrationEndpointsInitializer;
import org.springframework.integration.test.context.MockIntegrationContext;
import org.springframework.integration.test.context.SpringIntegrationTest;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class MockIntegrationContextCustomizer
implements ContextCustomizer {
    private final SpringIntegrationTest springIntegrationTest;

    MockIntegrationContextCustomizer(SpringIntegrationTest springIntegrationTest) {
        this.springIntegrationTest = springIntegrationTest;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory);
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        registry.registerBeanDefinition("mockIntegrationContext", (BeanDefinition)new RootBeanDefinition(MockIntegrationContext.class));
        String endpointsInitializer = Introspector.decapitalize(IntegrationEndpointsInitializer.class.getSimpleName());
        registry.registerBeanDefinition(endpointsInitializer, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(IntegrationEndpointsInitializer.class).addConstructorArgValue((Object)this.springIntegrationTest).getBeanDefinition());
    }
}

