/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.test.context.SpringIntegrationTest;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

class IntegrationEndpointsInitializer
implements SmartInitializingSingleton,
BeanFactoryAware {
    private final SpringIntegrationTest springIntegrationTest;
    private ConfigurableListableBeanFactory beanFactory;

    IntegrationEndpointsInitializer(SpringIntegrationTest springIntegrationTest) {
        this.springIntegrationTest = springIntegrationTest;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterSingletonsInstantiated() {
        Map endpoints = this.beanFactory.getBeansOfType(AbstractEndpoint.class);
        endpoints.entrySet().stream().filter(entry -> this.match((String)entry.getKey())).forEach(entry -> ((AbstractEndpoint)entry.getValue()).setAutoStartup(false));
    }

    private boolean match(String name) {
        for (String pattern : this.springIntegrationTest.noAutoStartup()) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)name)) continue;
            return true;
        }
        return false;
    }
}

