/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Map;
import org.hamcrest.Matcher;
import org.mockito.Matchers;
import org.springframework.integration.test.matcher.HeaderMatcher;
import org.springframework.integration.test.matcher.PayloadMatcher;
import org.springframework.messaging.Message;

public class MockitoMessageMatchers {
    public static <T> Message<T> messageWithPayload(Matcher<T> payloadMatcher) {
        return (Message)Matchers.argThat(PayloadMatcher.hasPayload(payloadMatcher));
    }

    public static <T> Message<T> messageWithPayload(T payload) {
        return (Message)Matchers.argThat(PayloadMatcher.hasPayload(payload));
    }

    public static Message<?> messageWithHeaderEntry(String key, Object value) {
        return (Message)Matchers.argThat(HeaderMatcher.hasHeader(key, value));
    }

    public static Message<?> messageWithHeaderKey(String key) {
        return (Message)Matchers.argThat(HeaderMatcher.hasHeaderKey(key));
    }

    public static <T> Message<?> messageWithHeaderEntry(String key, Matcher<T> valueMatcher) {
        return (Message)Matchers.argThat(HeaderMatcher.hasHeader(key, valueMatcher));
    }

    public static Message<?> messageWithHeaderEntries(Map<String, ?> entries) {
        return (Message)Matchers.argThat(HeaderMatcher.hasAllHeaders(entries));
    }
}

