/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.springframework.messaging.Message;

public class PayloadAndHeaderMatcher
extends BaseMatcher<Message<?>> {
    private final Object payload;
    private final Map<String, Object> headers;
    private final String[] ignoreKeys;

    @Factory
    public static Matcher<Message<?>> sameExceptIgnorableHeaders(Message<?> expected, String ... ignoreKeys) {
        return new PayloadAndHeaderMatcher(expected, ignoreKeys);
    }

    private PayloadAndHeaderMatcher(Message<?> expected, String ... ignoreKeys) {
        this.ignoreKeys = ignoreKeys;
        this.payload = expected.getPayload();
        this.headers = this.getHeaders(expected);
    }

    private Map<String, Object> getHeaders(Message<?> operand) {
        HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)operand.getHeaders());
        headers.remove("id");
        headers.remove("timestamp");
        for (String key : this.ignoreKeys) {
            headers.remove(key);
        }
        return headers;
    }

    public boolean matches(Object arg) {
        Message input = (Message)arg;
        Map<String, Object> inputHeaders = this.getHeaders(input);
        return input.getPayload().equals(this.payload) && inputHeaders.equals(this.headers);
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers that match except ID and timestamp for payload: ").appendValue(this.payload).appendText(" and headers: ").appendValue(this.headers);
    }
}

