/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import com.splunk.Args;
import com.splunk.Index;
import com.splunk.Receiver;
import com.splunk.Service;
import java.io.IOException;
import java.net.Socket;
import org.springframework.integration.splunk.core.ServiceFactory;
import org.springframework.integration.splunk.event.SplunkEvent;
import org.springframework.integration.splunk.support.AbstractSplunkDataWriter;

public class SplunkSubmitWriter
extends AbstractSplunkDataWriter {
    private String index;

    public SplunkSubmitWriter(ServiceFactory serviceFactory, Args args) {
        super(serviceFactory, args);
    }

    @Override
    protected void doWrite(SplunkEvent event, Socket socket, Service service, Args args) throws IOException {
        Index index = this.getIndex();
        if (index != null) {
            index.submit(args, event.toString());
        } else {
            Receiver receiver = service.getReceiver();
            receiver.submit(args, event.toString());
        }
    }

    @Override
    protected Socket createSocket(Service service) throws IOException {
        return null;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    private Index getIndex() {
        return this.index == null ? null : (Index)this.service.getIndexes().get((Object)this.index);
    }
}

