/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import com.splunk.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.splunk.core.ServiceFactory;
import org.springframework.integration.splunk.support.SplunkServer;
import org.springframework.util.Assert;

public class SplunkServiceFactory
implements ServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(SplunkServiceFactory.class);
    private final List<SplunkServer> splunkServers;
    private final Map<SplunkServer, Service> servicePerServer = new ConcurrentHashMap<SplunkServer, Service>();

    public SplunkServiceFactory(SplunkServer splunkServer) {
        Assert.notNull((Object)splunkServer);
        this.splunkServers = Arrays.asList(splunkServer);
    }

    public SplunkServiceFactory(List<SplunkServer> splunkServers) {
        Assert.notEmpty(splunkServers);
        this.splunkServers = new ArrayList<SplunkServer>(splunkServers);
    }

    @Override
    public synchronized Service getService() {
        return this.getServiceInternal();
    }

    private Service getServiceInternal() {
        for (SplunkServer splunkServer : this.splunkServers) {
            Service service = this.servicePerServer.get(splunkServer);
            if (service != null) {
                if (splunkServer.isCheckServiceOnBorrow() && !this.pingService(service)) continue;
                return service;
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Service> callable = this.buildServiceCallable(splunkServer);
            Future<Service> future = executor.submit(callable);
            try {
                service = splunkServer.getTimeout() > 0 ? future.get(splunkServer.getTimeout(), TimeUnit.MILLISECONDS) : future.get();
                this.servicePerServer.put(splunkServer, service);
                return service;
            }
            catch (Exception e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)String.format("could not connect to Splunk Server @ %s:%d - %s, try next one", splunkServer.getHost(), splunkServer.getPort(), e.getMessage()));
            }
        }
        String message = String.format("could not connect to any of Splunk Servers %s", this.splunkServers);
        LOGGER.error((Object)message);
        throw new RuntimeException(message);
    }

    private Callable<Service> buildServiceCallable(SplunkServer splunkServer) {
        final HashMap<String, Object> args = new HashMap<String, Object>();
        if (splunkServer.getHost() != null) {
            args.put("host", splunkServer.getHost());
        }
        if (splunkServer.getPort() != 0) {
            args.put("port", splunkServer.getPort());
        }
        if (splunkServer.getScheme() != null) {
            args.put("scheme", splunkServer.getScheme());
        }
        if (splunkServer.getApp() != null) {
            args.put("app", splunkServer.getApp());
        }
        if (splunkServer.getOwner() != null) {
            args.put("owner", splunkServer.getOwner());
        }
        args.put("username", splunkServer.getUsername());
        args.put("password", splunkServer.getPassword());
        String auth = splunkServer.getUsername() + ":" + splunkServer.getPassword();
        String authToken = "Basic " + DatatypeConverter.printBase64Binary((byte[])auth.getBytes());
        args.put("token", authToken);
        return new Callable<Service>(){

            @Override
            public Service call() throws Exception {
                return Service.connect((Map)args);
            }
        };
    }

    private boolean pingService(Service service) {
        try {
            service.getInfo();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

