/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import com.splunk.Args;
import com.splunk.Index;
import com.splunk.Receiver;
import com.splunk.Service;
import java.io.IOException;
import java.net.Socket;
import org.springframework.integration.splunk.core.ServiceFactory;
import org.springframework.integration.splunk.support.AbstractSplunkDataWriter;
import org.springframework.util.Assert;

public class SplunkIndexWriter
extends AbstractSplunkDataWriter {
    private String index;

    public SplunkIndexWriter(ServiceFactory serviceFactory, Args args) {
        super(serviceFactory, args);
    }

    @Override
    protected Socket createSocket(Service service) throws IOException {
        Index indexObject = null;
        Receiver receiver = null;
        Socket socket = null;
        if (this.index != null) {
            indexObject = (Index)service.getIndexes().get((Object)this.index);
            Assert.notNull((Object)indexObject, (String)String.format("cannot find index [%s]", this.index));
            socket = indexObject.attach(this.args);
        } else {
            receiver = service.getReceiver();
            socket = receiver.attach(this.args);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("created a socket on %s", socket.getRemoteSocketAddress()));
        }
        return socket;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }
}

