/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.splunk.core.DataReader;
import org.springframework.integration.splunk.core.DataWriter;
import org.springframework.integration.splunk.event.SplunkEvent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;

public class SplunkExecutor {
    private static final Log logger = LogFactory.getLog(SplunkExecutor.class);
    private DataReader reader;
    private DataWriter writer;

    public Object write(Message<?> message) {
        try {
            SplunkEvent payload = (SplunkEvent)message.getPayload();
            this.writer.write(payload);
        }
        catch (Exception e) {
            String errorMsg = "error in writing data into Splunk";
            logger.warn((Object)errorMsg, (Throwable)e);
            throw new MessageHandlingException(message, errorMsg, (Throwable)e);
        }
        return null;
    }

    public void handleMessage(Message<?> message) {
        this.write(message);
    }

    public List<SplunkEvent> poll() {
        logger.debug((Object)"poll start:");
        List<SplunkEvent> queryData = null;
        try {
            queryData = this.reader.read();
        }
        catch (Exception e) {
            String errorMsg = "search Splunk data failed";
            logger.warn((Object)errorMsg, (Throwable)e);
            throw new MessagingException(errorMsg, (Throwable)e);
        }
        return queryData;
    }

    public void setReader(DataReader reader) {
        this.reader = reader;
    }

    public void setWriter(DataWriter writer) {
        this.writer = writer;
    }
}

