/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import com.splunk.Args;
import com.splunk.Event;
import com.splunk.Job;
import com.splunk.ResultsReaderXml;
import com.splunk.SavedSearch;
import com.splunk.SavedSearchCollection;
import com.splunk.Service;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.splunk.core.DataReader;
import org.springframework.integration.splunk.core.ServiceFactory;
import org.springframework.integration.splunk.event.SplunkEvent;
import org.springframework.integration.splunk.support.SearchMode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SplunkDataReader
implements DataReader,
InitializingBean {
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss:SSS";
    private static final String SPLUNK_TIME_FORMAT = "%m/%d/%y %H:%M:%S:%3N";
    private static final Log logger = LogFactory.getLog(SplunkDataReader.class);
    private SearchMode mode;
    private int count = 0;
    private String fieldList;
    private String search;
    private String earliestTime;
    private String latestTime;
    private String savedSearch;
    private String owner;
    private String app;
    private String initEarliestTime;
    private transient Calendar lastSuccessfulReadTime;
    private final ServiceFactory serviceFactory;

    public SplunkDataReader(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public void setSearch(String searchStr) {
        Assert.hasText((String)searchStr, (String)"search must be neither null nor empty");
        this.search = searchStr;
    }

    public void setEarliestTime(String earliestTime) {
        this.earliestTime = earliestTime;
    }

    public void setLatestTime(String latestTime) {
        this.latestTime = latestTime;
    }

    public void setSavedSearch(String savedSearch) {
        this.savedSearch = savedSearch;
    }

    public void setMode(SearchMode mode) {
        Assert.notNull((Object)((Object)mode), (String)"mode must be set");
        this.mode = mode;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setInitEarliestTime(String initEarliestTime) {
        Assert.notNull((Object)initEarliestTime, (String)"initial earliest time can not be null");
        this.initEarliestTime = initEarliestTime;
    }

    public SearchMode getMode() {
        return this.mode;
    }

    public int getCount() {
        return this.count;
    }

    public String getFieldList() {
        return this.fieldList;
    }

    public String getSearch() {
        return this.search;
    }

    public String getEarliestTime() {
        return this.earliestTime;
    }

    public String getLatestTime() {
        return this.latestTime;
    }

    public String getSavedSearch() {
        return this.savedSearch;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getInitEarliestTime() {
        return this.initEarliestTime;
    }

    public String getApp() {
        return this.app;
    }

    @Override
    public List<SplunkEvent> read() throws Exception {
        logger.debug((Object)("mode:" + (Object)((Object)this.mode)));
        switch (this.mode) {
            case SAVEDSEARCH: {
                return this.savedSearch();
            }
            case BLOCKING: {
                return this.blockingSearch();
            }
            case NORMAL: {
                return this.nonBlockingSearch();
            }
            case EXPORT: {
                return this.exportSearch();
            }
            case REALTIME: {
                throw new UnsupportedOperationException("The 'real-time' search isn't supported because of the infinite Splunk Job nature.");
            }
        }
        return null;
    }

    private String calculateEarliestTime(Calendar startTime, boolean realtime) {
        String result = null;
        if (realtime) {
            result = this.calculateEarliestTimeForRealTime(startTime);
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        result = df.format(this.lastSuccessfulReadTime.getTime());
        return result;
    }

    private String calculateEarliestTimeForRealTime(Calendar startTime) {
        String result = null;
        long diff = startTime.getTimeInMillis() - this.lastSuccessfulReadTime.getTimeInMillis();
        result = "-" + diff / 1000L + "s";
        return result;
    }

    private void populateArgs(Args queryArgs, Calendar startTime, boolean realtime) {
        String latestTime;
        String earliestTime = this.getEarliestTime(startTime, realtime);
        if (StringUtils.hasText((String)earliestTime)) {
            queryArgs.put((Object)"earliest_time", (Object)earliestTime);
        }
        if (StringUtils.hasText((String)(latestTime = this.getLatestTime(startTime, realtime)))) {
            queryArgs.put((Object)"latest_time", (Object)latestTime);
        }
        queryArgs.put((Object)"time_format", (Object)SPLUNK_TIME_FORMAT);
        if (StringUtils.hasText((String)this.fieldList)) {
            queryArgs.put((Object)"field_list", (Object)this.fieldList);
        }
    }

    private String getLatestTime(Calendar startTime, boolean realtime) {
        String lTime = null;
        if (StringUtils.hasText((String)this.latestTime)) {
            lTime = this.latestTime;
        } else if (realtime) {
            lTime = "rt";
        } else {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            lTime = df.format(startTime.getTime());
        }
        return lTime;
    }

    private String getEarliestTime(Calendar startTime, boolean realtime) {
        String eTime = null;
        if (this.lastSuccessfulReadTime == null) {
            eTime = this.initEarliestTime;
        } else if (StringUtils.hasText((String)this.earliestTime)) {
            eTime = this.earliestTime;
        } else {
            String calculatedEarliestTime = this.calculateEarliestTime(startTime, realtime);
            if (calculatedEarliestTime != null) {
                eTime = realtime ? "rt" + calculatedEarliestTime : calculatedEarliestTime;
            }
        }
        return eTime;
    }

    private List<SplunkEvent> runQuery(Args queryArgs) throws Exception {
        Service service = this.serviceFactory.getService();
        Job job = service.getJobs().create(this.search, (Map)queryArgs);
        while (!job.isDone()) {
            Thread.sleep(2000L);
        }
        return this.extractData(job);
    }

    private List<SplunkEvent> blockingSearch() throws Exception {
        logger.debug((Object)"block search start");
        Args queryArgs = new Args();
        queryArgs.put((Object)"exec_mode", (Object)"blocking");
        Calendar startTime = Calendar.getInstance();
        this.populateArgs(queryArgs, startTime, false);
        List<SplunkEvent> data = this.runQuery(queryArgs);
        this.lastSuccessfulReadTime = startTime;
        return data;
    }

    private List<SplunkEvent> nonBlockingSearch() throws Exception {
        logger.debug((Object)"non block search start");
        Args queryArgs = new Args();
        queryArgs.put((Object)"exec_mode", (Object)"normal");
        Calendar startTime = Calendar.getInstance();
        this.populateArgs(queryArgs, startTime, false);
        List<SplunkEvent> data = this.runQuery(queryArgs);
        this.lastSuccessfulReadTime = startTime;
        return data;
    }

    private List<SplunkEvent> realtimeSearch() throws Exception {
        logger.debug((Object)"realtime search start");
        Args queryArgs = new Args();
        queryArgs.put((Object)"search_mode", (Object)"realtime");
        Calendar startTime = Calendar.getInstance();
        this.populateArgs(queryArgs, startTime, true);
        List<SplunkEvent> data = this.runQuery(queryArgs);
        this.lastSuccessfulReadTime = startTime;
        return data;
    }

    private List<SplunkEvent> exportSearch() throws Exception {
        Event data;
        logger.debug((Object)"export start");
        ArrayList<SplunkEvent> result = new ArrayList<SplunkEvent>();
        Args queryArgs = new Args();
        Calendar startTime = Calendar.getInstance();
        this.populateArgs(queryArgs, startTime, false);
        queryArgs.put((Object)"output_mode", (Object)"xml");
        Service service = this.serviceFactory.getService();
        InputStream os = service.export(this.search, (Map)queryArgs);
        ResultsReaderXml resultsReader = new ResultsReaderXml(os);
        while ((data = resultsReader.getNextEvent()) != null) {
            SplunkEvent splunkData = new SplunkEvent((Map<String, String>)data);
            result.add(splunkData);
        }
        return result;
    }

    private List<SplunkEvent> savedSearch() throws Exception {
        logger.debug((Object)"saved search start");
        Args queryArgs = new Args();
        queryArgs.put((Object)"app", (Object)"search");
        if (this.owner != null && this.owner.length() > 0) {
            queryArgs.put((Object)"owner", (Object)this.owner);
        }
        if (this.app != null && this.app.length() > 0) {
            queryArgs.put((Object)"app", (Object)this.app);
        }
        Calendar startTime = Calendar.getInstance();
        SavedSearch search = null;
        Job job = null;
        String latestTime = this.getLatestTime(startTime, false);
        String earliestTime = this.getEarliestTime(startTime, false);
        Service service = this.serviceFactory.getService();
        SavedSearchCollection savedSearches = service.getSavedSearches(queryArgs);
        for (SavedSearch s : savedSearches.values()) {
            if (!s.getName().equals(this.savedSearch)) continue;
            search = s;
        }
        if (search != null) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("force_dispatch", "true");
            args.put("dispatch.earliest_time", earliestTime);
            args.put("dispatch.latest_time", latestTime);
            job = search.dispatch(args);
        }
        while (!job.isDone()) {
            Thread.sleep(2000L);
        }
        List<SplunkEvent> data = this.extractData(job);
        this.lastSuccessfulReadTime = startTime;
        return data;
    }

    private List<SplunkEvent> extractData(Job job) throws Exception {
        ArrayList<SplunkEvent> result = new ArrayList<SplunkEvent>();
        int total = job.getResultCount();
        if (this.count == 0 || total < this.count) {
            Event data;
            InputStream stream = null;
            Args outputArgs = new Args();
            outputArgs.put((Object)"count", (Object)this.count);
            outputArgs.put((Object)"output_mode", (Object)"xml");
            stream = job.getResults((Map)outputArgs);
            ResultsReaderXml resultsReader = new ResultsReaderXml(stream);
            while ((data = resultsReader.getNextEvent()) != null) {
                SplunkEvent splunkData = new SplunkEvent((Map<String, String>)data);
                result.add(splunkData);
            }
        } else {
            for (int offset = 0; offset < total; offset += this.count) {
                Event data;
                InputStream stream = null;
                Args outputArgs = new Args();
                outputArgs.put((Object)"output_mode", (Object)"xml");
                outputArgs.put((Object)"count", (Object)this.count);
                outputArgs.put((Object)"offset", (Object)offset);
                stream = job.getResults((Map)outputArgs);
                ResultsReaderXml resultsReader = new ResultsReaderXml(stream);
                while ((data = resultsReader.getNextEvent()) != null) {
                    SplunkEvent splunkData = new SplunkEvent((Map<String, String>)data);
                    result.add(splunkData);
                }
            }
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.initEarliestTime, (String)"initial earliest time can not be null");
    }
}

