/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.support;

import com.splunk.Args;
import com.splunk.Service;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.splunk.core.DataWriter;
import org.springframework.integration.splunk.core.ServiceFactory;
import org.springframework.integration.splunk.event.SplunkEvent;
import org.springframework.util.Assert;

public abstract class AbstractSplunkDataWriter
implements DataWriter,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Socket socket;
    protected Service service;
    protected Args args;
    private boolean running;
    private int phase;
    private boolean autoStartup = true;
    private final ServiceFactory serviceFactory;

    protected AbstractSplunkDataWriter(ServiceFactory serviceFactory, Args args) {
        Assert.notNull((Object)serviceFactory, (String)"service factory cannot be null");
        this.serviceFactory = serviceFactory;
        Assert.notNull((Object)args, (String)"args cannot be null");
        this.args = args;
    }

    @Override
    public void write(SplunkEvent event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("writing event to splunk:" + event));
        }
        this.doWrite(event, this.socket, this.service, this.args);
    }

    protected void doWrite(SplunkEvent event, Socket socket, Service service, Args args) throws IOException {
        OutputStream ostream = socket.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(ostream, "UTF8");
        writer.write(event.toString());
        ((Writer)writer).flush();
    }

    protected abstract Socket createSocket(Service var1) throws IOException;

    public Args getArgs() {
        return this.args;
    }

    public synchronized void start() {
        try {
            this.service = this.serviceFactory.getService();
            this.socket = this.createSocket(this.service);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.running = true;
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public synchronized void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

