/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.outbound;

import java.util.Map;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.splunk.support.SplunkExecutor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class SplunkOutboundChannelAdapter
extends AbstractReplyProducingMessageHandler {
    private final SplunkExecutor splunkExecutor;
    private boolean producesReply = true;

    public SplunkOutboundChannelAdapter(SplunkExecutor splunkExecutor) {
        Assert.notNull((Object)splunkExecutor, (String)"splunkExecutor must not be null.");
        this.splunkExecutor = splunkExecutor;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object result = this.splunkExecutor.write(requestMessage);
        if (result == null || !this.producesReply) {
            return null;
        }
        return MessageBuilder.withPayload((Object)result).copyHeaders((Map)requestMessage.getHeaders()).build();
    }

    public void setProducesReply(boolean producesReply) {
        this.producesReply = producesReply;
    }
}

