/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.inbound;

import java.util.List;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.splunk.event.SplunkEvent;
import org.springframework.integration.splunk.support.SplunkExecutor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class SplunkPollingChannelAdapter
extends IntegrationObjectSupport
implements MessageSource<List<SplunkEvent>> {
    private final SplunkExecutor splunkExecutor;

    public SplunkPollingChannelAdapter(SplunkExecutor splunkExecutor) {
        Assert.notNull((Object)splunkExecutor, (String)"splunkExecutor must not be null.");
        this.splunkExecutor = splunkExecutor;
    }

    protected void onInit() throws Exception {
        super.onInit();
    }

    public Message<List<SplunkEvent>> receive() {
        List<SplunkEvent> payload = this.splunkExecutor.poll();
        if (payload == null) {
            return null;
        }
        return MessageBuilder.withPayload(payload).build();
    }

    public String getComponentType() {
        return "splunk:inbound-channel-adapter";
    }
}

