/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.event;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.util.Assert;

public class SplunkEvent
implements Serializable {
    private StringBuffer eventMessage;
    protected boolean quoteValues = true;
    protected boolean useInternalDate = true;
    protected static final String KVDELIM = "=";
    protected static final String PAIRDELIM = " ";
    protected static final char QUOTE = '\"';
    protected static final String DATEFORMATPATTERN = "yyyy-MM-dd\tHH:mm:ss:SSSZ";
    protected static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd\tHH:mm:ss:SSSZ");
    protected static final String PREFIX_NAME = "name";
    protected static final String PREFIX_EVENT_ID = "event_id";
    protected static final String THROWABLE_CLASS = "throwable_class";
    protected static final String THROWABLE_MESSAGE = "throwable_message";
    protected static final String THROWABLE_STACKTRACE_ELEMENTS = "stacktrace_elements";
    protected static final String LINEBREAK = "\n";
    public static String COMMON_CATEGORY = "category";
    public static String COMMON_COUNT = "count";
    public static String COMMON_DESC = "desc";
    public static String COMMON_DHCP_POOL = "dhcp_pool";
    public static String COMMON_DURATION = "duration";
    public static String COMMON_DVC_HOST = "dvc_host";
    public static String COMMON_DVC_IP = "dvc_ip";
    public static String COMMON_DVC_IP6 = "dvc_ip6";
    public static String COMMON_DVC_LOCATION = "dvc_location";
    public static String COMMON_DVC_MAC = "dvc_mac";
    public static String COMMON_DVC_NT_DOMAIN = "dvc_nt_domain";
    public static String COMMON_DVC_NT_HOST = "dvc_nt_host";
    public static String COMMON_DVC_TIME = "dvc_time";
    public static String COMMON_END_TIME = "end_time";
    public static String COMMON_EVENT_ID = "event_id";
    public static String COMMON_LENGTH = "length";
    public static String COMMON_LOG_LEVEL = "log_level";
    public static String COMMON_NAME = "name";
    public static String COMMON_PID = "pid";
    public static String COMMON_PRIORITY = "priority";
    public static String COMMON_PRODUCT = "product";
    public static String COMMON_PRODUCT_VERSION = "product_version";
    public static String COMMON_REASON = "reason";
    public static String COMMON_RESULT = "result";
    public static String COMMON_SEVERITY = "severity";
    public static String COMMON_START_TIME = "start_time";
    public static String COMMON_TRANSACTION_ID = "transaction_id";
    public static String COMMON_URL = "url";
    public static String COMMON_VENDOR = "vendor";
    public static String UPDATE_PACKAGE = "package";

    public SplunkEvent(Map<String, String> data) {
        this.eventMessage = new StringBuffer();
        for (String key : data.keySet()) {
            this.addPair(key, data.get(key));
        }
    }

    public SplunkEvent(SplunkEvent splunkEvent) {
        this.eventMessage = splunkEvent.eventMessage;
        this.quoteValues = splunkEvent.quoteValues;
        this.useInternalDate = splunkEvent.useInternalDate;
    }

    public SplunkEvent(String eventName, String eventID, boolean useInternalDate, boolean quoteValues) {
        this.eventMessage = new StringBuffer();
        this.quoteValues = quoteValues;
        this.useInternalDate = useInternalDate;
        this.addPair(PREFIX_NAME, eventName);
        this.addPair(PREFIX_EVENT_ID, eventID);
    }

    public SplunkEvent(String eventName, String eventID) {
        this(eventName, eventID, true, true);
    }

    public SplunkEvent() {
        this.eventMessage = new StringBuffer();
    }

    public Map<String, String> getEventData() {
        HashMap<String, String> eventData = new HashMap<String, String>();
        String eventEntries = this.eventMessage.toString();
        String[] entries = eventEntries.split(PAIRDELIM);
        String quote = new String(new char[]{'\"'});
        for (String entry : entries) {
            String[] pair = entry.split(KVDELIM);
            Assert.isTrue((pair.length == 2 ? 1 : 0) != 0, (String)String.format("invalid event data [%s]", entry));
            String key = pair[0].replaceAll(quote, "");
            String value = pair[1].replaceAll(quote, "");
            if ("null".equals(value)) {
                value = null;
            }
            eventData.put(key, value);
        }
        return eventData;
    }

    public void addPair(String key, char value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, boolean value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, double value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, long value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, int value) {
        this.addPair(key, String.valueOf(value));
    }

    public void addPair(String key, Object value) {
        this.addPair(key, value.toString());
    }

    public void addThrowable(Throwable throwable) {
        this.addThrowableObject(throwable, -1);
    }

    public void addThrowable(Throwable throwable, int stackTraceDepth) {
        this.addThrowableObject(throwable, stackTraceDepth);
    }

    private void addThrowableObject(Throwable throwable, int stackTraceDepth) {
        this.addPair(THROWABLE_CLASS, throwable.getClass().getCanonicalName());
        this.addPair(THROWABLE_MESSAGE, throwable.getMessage());
        StackTraceElement[] elements = throwable.getStackTrace();
        StringBuffer sb = new StringBuffer();
        int depth = 0;
        for (StackTraceElement element : elements) {
            if (stackTraceDepth != -1 && stackTraceDepth < ++depth) break;
            sb.append(element.toString()).append(",");
        }
        this.addPair(THROWABLE_STACKTRACE_ELEMENTS, sb.toString());
    }

    public void addPair(String key, String value) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        if (this.quoteValues) {
            this.eventMessage.append(key).append(KVDELIM).append('\"').append(value).append('\"').append(PAIRDELIM);
        } else {
            this.eventMessage.append(key).append(KVDELIM).append(value).append(PAIRDELIM);
        }
    }

    public String toString() {
        String event = "";
        if (this.useInternalDate) {
            StringBuffer clonedMessage = new StringBuffer();
            clonedMessage.append(DATE_FORMATTER.print(new Date().getTime())).append(PAIRDELIM).append(this.eventMessage);
            event = clonedMessage.toString();
        } else {
            event = this.eventMessage.toString();
        }
        String result = event.substring(0, event.length() - PAIRDELIM.length()) + LINEBREAK;
        return result;
    }

    public void setCommonCategory(String commonCategory) {
        this.addPair(COMMON_CATEGORY, commonCategory);
    }

    public void setCommonCount(String commonCount) {
        this.addPair(COMMON_COUNT, commonCount);
    }

    public void setCommonDesc(String commonDesc) {
        this.addPair(COMMON_DESC, commonDesc);
    }

    public void setCommonDhcpPool(String commonDhcpPool) {
        this.addPair(COMMON_DHCP_POOL, commonDhcpPool);
    }

    public void setCommonDuration(long commonDuration) {
        this.addPair(COMMON_DURATION, commonDuration);
    }

    public void setCommonDvcHost(String commonDvcHost) {
        this.addPair(COMMON_DVC_HOST, commonDvcHost);
    }

    public void setCommonDvcIp(String commonDvcIp) {
        this.addPair(COMMON_DVC_IP, commonDvcIp);
    }

    public void setCommonDvcIp6(String commonDvcIp6) {
        this.addPair(COMMON_DVC_IP6, commonDvcIp6);
    }

    public void setCommonDvcLocation(String commonDvcLocation) {
        this.addPair(COMMON_DVC_LOCATION, commonDvcLocation);
    }

    public void setCommonDvcMac(String commonDvcMac) {
        this.addPair(COMMON_DVC_MAC, commonDvcMac);
    }

    public void setCommonDvcNtDomain(String commonDvcNtDomain) {
        this.addPair(COMMON_DVC_NT_DOMAIN, commonDvcNtDomain);
    }

    public void setCommonDvcNtHost(String commonDvcNtHost) {
        this.addPair(COMMON_DVC_NT_HOST, commonDvcNtHost);
    }

    public void setCommonDvcTime(long commonDvcTime) {
        this.addPair(COMMON_DVC_TIME, commonDvcTime);
    }

    public void setCommonEndTime(long commonEndTime) {
        this.addPair(COMMON_END_TIME, commonEndTime);
    }

    public void setCommonEventId(long commonEventId) {
        this.addPair(COMMON_EVENT_ID, commonEventId);
    }

    public void setCommonLength(long commonLength) {
        this.addPair(COMMON_LENGTH, commonLength);
    }

    public void setCommonLogLevel(String commonLogLevel) {
        this.addPair(COMMON_LOG_LEVEL, commonLogLevel);
    }

    public void setCommonName(String commonName) {
        this.addPair(COMMON_NAME, commonName);
    }

    public void setCommonPid(long commonPid) {
        this.addPair(COMMON_PID, commonPid);
    }

    public void setCommonPriority(long commonPriority) {
        this.addPair(COMMON_PRIORITY, commonPriority);
    }

    public void setCommonProduct(String commonProduct) {
        this.addPair(COMMON_PRODUCT, commonProduct);
    }

    public void setCommonProductVersion(long commonProductVersion) {
        this.addPair(COMMON_PRODUCT_VERSION, commonProductVersion);
    }

    public void setCommonReason(String commonReason) {
        this.addPair(COMMON_REASON, commonReason);
    }

    public void setCommonResult(String commonResult) {
        this.addPair(COMMON_RESULT, commonResult);
    }

    public void setCommonSeverity(String commonSeverity) {
        this.addPair(COMMON_SEVERITY, commonSeverity);
    }

    public void setCommonStartTime(long commonStartTime) {
        this.addPair(COMMON_START_TIME, commonStartTime);
    }

    public void setCommonTransactionId(String commonTransactionId) {
        this.addPair(COMMON_TRANSACTION_ID, commonTransactionId);
    }

    public void setCommonUrl(String commonUrl) {
        this.addPair(COMMON_URL, commonUrl);
    }

    public void setCommonVendor(String commonVendor) {
        this.addPair(COMMON_VENDOR, commonVendor);
    }

    public void setUpdatePackage(String updatePackage) {
        this.addPair(UPDATE_PACKAGE, updatePackage);
    }
}

