/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.splunk.config.xml.SplunkParserUtils;
import org.springframework.integration.splunk.outbound.SplunkOutboundChannelAdapter;
import org.springframework.integration.splunk.support.SplunkArgsFactoryBean;
import org.springframework.integration.splunk.support.SplunkIndexWriter;
import org.springframework.integration.splunk.support.SplunkServiceFactory;
import org.springframework.integration.splunk.support.SplunkSubmitWriter;
import org.springframework.integration.splunk.support.SplunkTcpWriter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SplunkOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder splunkOutboundChannelAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkOutboundChannelAdapter.class);
        BeanDefinitionBuilder splunkExecutorBuilder = SplunkParserUtils.getSplunkExecutorBuilder(element, parserContext);
        BeanDefinitionBuilder argsBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkArgsFactoryBean.class);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)argsBuilder, (Element)element, (String)"source-type");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)argsBuilder, (Element)element, (String)"source");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)argsBuilder, (Element)element, (String)"host");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)argsBuilder, (Element)element, (String)"host-regex");
        BeanDefinitionBuilder dataWriterBuilder = this.parseDataWriter(element);
        BeanDefinitionBuilder serviceFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkServiceFactory.class);
        String splunkServerBeanNames = element.getAttribute("splunk-server-ref");
        if (StringUtils.hasText((String)splunkServerBeanNames)) {
            ManagedList splunkServersList = new ManagedList();
            for (String splunkServerBeanName : StringUtils.delimitedListToStringArray((String)splunkServerBeanNames, (String)";")) {
                splunkServersList.add((Object)new RuntimeBeanReference(splunkServerBeanName));
            }
            serviceFactoryBuilder.addConstructorArgValue((Object)splunkServersList);
        }
        dataWriterBuilder.addConstructorArgValue((Object)serviceFactoryBuilder.getBeanDefinition());
        dataWriterBuilder.addConstructorArgValue((Object)argsBuilder.getBeanDefinition());
        String channelAdapterId = this.resolveId(element, splunkOutboundChannelAdapterBuilder.getRawBeanDefinition(), parserContext);
        String splunkExecutorBeanName = channelAdapterId + ".splunkExecutor";
        String splunkDataWriterBeanName = splunkExecutorBeanName + ".writer";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)dataWriterBuilder.getBeanDefinition(), splunkDataWriterBeanName));
        splunkExecutorBuilder.addPropertyReference("writer", splunkDataWriterBeanName);
        AbstractBeanDefinition splunkExecutorBuilderBeanDefinition = splunkExecutorBuilder.getBeanDefinition();
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)splunkExecutorBuilderBeanDefinition, splunkExecutorBeanName));
        splunkOutboundChannelAdapterBuilder.addConstructorArgReference(splunkExecutorBeanName);
        splunkOutboundChannelAdapterBuilder.addPropertyValue("producesReply", (Object)Boolean.FALSE);
        return splunkOutboundChannelAdapterBuilder.getBeanDefinition();
    }

    private BeanDefinitionBuilder parseDataWriter(Element element) {
        Element dataWriter;
        BeanDefinitionBuilder dataWriterBuilder = null;
        if (DomUtils.getChildElementByTagName((Element)element, (String)"index-writer") != null) {
            dataWriter = DomUtils.getChildElementByTagName((Element)element, (String)"index-writer");
            dataWriterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkIndexWriter.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)dataWriterBuilder, (Element)dataWriter, (String)"index");
        }
        if (DomUtils.getChildElementByTagName((Element)element, (String)"submit-writer") != null) {
            dataWriter = DomUtils.getChildElementByTagName((Element)element, (String)"submit-writer");
            dataWriterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkSubmitWriter.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)dataWriterBuilder, (Element)dataWriter, (String)"index");
        }
        if (DomUtils.getChildElementByTagName((Element)element, (String)"tcp-writer") != null) {
            dataWriter = DomUtils.getChildElementByTagName((Element)element, (String)"tcp-writer");
            dataWriterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkTcpWriter.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)dataWriterBuilder, (Element)dataWriter, (String)"port");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)dataWriterBuilder, (Element)element, (String)"auto-startup");
        return dataWriterBuilder;
    }
}

