/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splunk.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.splunk.config.xml.SplunkParserUtils;
import org.springframework.integration.splunk.inbound.SplunkPollingChannelAdapter;
import org.springframework.integration.splunk.support.SplunkDataReader;
import org.springframework.integration.splunk.support.SplunkServiceFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SplunkInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder splunkPollingChannelAdapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkPollingChannelAdapter.class);
        BeanDefinitionBuilder splunkExecutorBuilder = SplunkParserUtils.getSplunkExecutorBuilder(element, parserContext);
        BeanDefinitionBuilder splunkDataReaderBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkDataReader.class);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"mode");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"count");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"field-list");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"search");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"saved-search");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"owner");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"app");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"init-earliest-time");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"earliest-time");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)splunkDataReaderBuilder, (Element)element, (String)"latest-time");
        BeanDefinitionBuilder serviceFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SplunkServiceFactory.class);
        String splunkServerBeanNames = element.getAttribute("splunk-server-ref");
        if (StringUtils.hasText((String)splunkServerBeanNames)) {
            ManagedList splunkServersList = new ManagedList();
            for (String splunkServerBeanName : StringUtils.commaDelimitedListToStringArray((String)splunkServerBeanNames)) {
                splunkServersList.add((Object)new RuntimeBeanReference(splunkServerBeanName));
            }
            serviceFactoryBuilder.addConstructorArgValue((Object)splunkServersList);
            splunkDataReaderBuilder.addConstructorArgValue((Object)serviceFactoryBuilder.getBeanDefinition());
        }
        String channelAdapterId = this.resolveId(element, splunkPollingChannelAdapterBuilder.getRawBeanDefinition(), parserContext);
        String splunkExecutorBeanName = channelAdapterId + ".splunkExecutor";
        String splunkDataReaderBeanName = splunkExecutorBeanName + ".reader";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)splunkDataReaderBuilder.getBeanDefinition(), splunkDataReaderBeanName));
        splunkExecutorBuilder.addPropertyReference("reader", splunkDataReaderBeanName);
        AbstractBeanDefinition splunkExecutorBuilderBeanDefinition = splunkExecutorBuilder.getBeanDefinition();
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)splunkExecutorBuilderBeanDefinition, splunkExecutorBeanName));
        splunkPollingChannelAdapterBuilder.addConstructorArgReference(splunkExecutorBeanName);
        return splunkPollingChannelAdapterBuilder.getBeanDefinition();
    }
}

