/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.outbound;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;
import org.springframework.integration.sftp.support.GeneralSftpException;

public class SftpMessageHandler
extends FileTransferringMessageHandler<ChannelSftp.LsEntry> {
    public SftpMessageHandler(SftpRemoteFileTemplate remoteFileTemplate) {
        super((RemoteFileTemplate)remoteFileTemplate);
    }

    public SftpMessageHandler(SftpRemoteFileTemplate remoteFileTemplate, FileExistsMode mode) {
        super((RemoteFileTemplate)remoteFileTemplate, mode);
    }

    public SftpMessageHandler(SessionFactory<ChannelSftp.LsEntry> sessionFactory) {
        this(new SftpRemoteFileTemplate(sessionFactory));
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileTemplate<ChannelSftp.LsEntry> remoteFileTemplate, String path, int chmod) {
        remoteFileTemplate.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            try {
                client.chmod(chmod, path);
            }
            catch (SftpException e) {
                throw new GeneralSftpException("Failed to execute chmod", e);
            }
        }));
    }
}

