/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.channel;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class ChannelInvocation {
    private final MessageChannel channel;
    private final Message<?> message;
    private final MethodInvocation methodInvocation;

    public ChannelInvocation(MethodInvocation methodInvocation) {
        Assert.notNull((Object)methodInvocation, (String)"MethodInvocation must not be null");
        Assert.isAssignable(MessageChannel.class, methodInvocation.getThis().getClass(), (String)"MethodInvocation must be on a MessageChannel");
        this.channel = (MessageChannel)methodInvocation.getThis();
        if (methodInvocation.getMethod().getName().equals("send")) {
            if (methodInvocation.getArguments().length < 1 || !(methodInvocation.getArguments()[0] instanceof Message)) {
                throw new IllegalStateException("expected a Message as the first parameter of the channel's send method");
            }
            this.message = (Message)methodInvocation.getArguments()[0];
        } else {
            this.message = null;
        }
        this.methodInvocation = methodInvocation;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public Message<?> getMessage() {
        return this.message;
    }

    public MethodInvocation getMethodInvocation() {
        return this.methodInvocation;
    }

    public boolean isSend() {
        return "send".equals(this.methodInvocation.getMethod().getName());
    }

    public boolean isReceive() {
        return "receive".equals(this.methodInvocation.getMethod().getName());
    }
}

